#ifndef DATALOG_H
#define DATALOG_H

#include <QString>
#include <QVector>
#include <QStringList>
#include <QMap>
#include <QFile>
#include <QTextStream>
#include <QReadWriteLock>
#include "rftablemodel.h"
#include "dynamic_column.h"

#include "muparser/include/muParser.h"

class rfdatalog : public rftablemodel {
public:
  rfdatalog();
  rfdatalog(const rfdatalog &other);
  ~rfdatalog();
  int id() const;
  _table_type table_type() const override { return DATALOG; };

  void configure_log(char seperator, int header_line, int data_line, bool allow_shitty_csv,
                     bool parse_boolean_text, int max_lines, const QString &time_col);

  int time_col = -1; // -1 = use row count as time index.
  int seek(const int &current_row, const double &time) const;

  bool is_valid() const;
  bool auto_col_size() const override { return false; };

  bool load_file(const QString &filename);
  QString name;

  bool matches(const QStringList &columns) const;
  int index_of(const QString &col_name) const;

  int n_columns() const override;
  int n_rows() const override;

  QString col_name(const int &col) const override;
  QString row_name(const int &row) const override;
  int col_custom_size(const int &col) const override;
  QString x_axis_name() const override { return name; };
  QString y_axis_name() const override { return QString(); };

  QString string_at(const int &row, const int &col) const override;
  double double_at(const int &row, const int &col) const override;
  QStringList column_string_list(bool exclude_extra_columns = false) const;

  QVector <double>value_list() const override { return QVector<double>(); };

  QStringList parse_errors;

  int data_index(const int &row, const int &col) const;

  QString header_at(const int &col) const;
  int header_index(const int &col) const;

  QVector<double>col_vector(const int &col) const;

  // generate a list of columns that exist in all these datalogs.
  static QStringList common_columns(QVector<rfdatalog *> logs);

  // reload the dynamic columns that are valid.
  void reload_dynamic_columns(dynamic_column_list *list);

private:
  QFile *file = nullptr;
  QVector <double>data_double;
  QStringList data_str;
  QVector <int>col_size_cache;
  int _n_cols = -1;

  int header_line = 0;
  int data_line = 1;
  char seperator = ',';
  bool allow_shitty_csv = false;
  bool parse_boolean_text = false;
  bool fast_converter = true;
  QString time_col_name;
  int max_lines = __INT_MAX__;

  int _id = 0;
  bool parse_csv();
  bool parse_csv_new(QDataStream *stream, bool errors_fatal, char seperator, int max_lines, QStringList *parse_errors, int file_size);
  mutable QMap<int,QVector<double>>col_cache;

  QStringList columns;
  QMap <QString,int>column_map;

  inline void append_raw_data(QByteArray *f);
  bool seek_stream_line(QDataStream *stream, int _line_number);

  bool handle_backslash = true;
  bool handle_quotes = true;
  bool handle_literal_quotes = true;

  QVector <QVector<double>>extra_col_data;
  QStringList extra_col_names;
  QVector <int>extra_col_size_cache;
};

#endif // DATALOG_H
