#include "color_scale_dialog.h"
#include "ui_color_scale_dialog.h"
#include "../widgets/color_button.h"
#include "../dialogs/database_dialog.h"
#include <QColorDialog>

color_scale_dialog::color_scale_dialog(color_scale scale, QVector<double> values, QWidget *parent) :
  QDialog(parent),
  ui(new Ui::color_scale_dialog) {
  ui->setupUi(this);
  this->scale = scale;
  scale_to_ui();
  this->values = values;
  ui->estimate_btn->setEnabled(! values.isEmpty());
}

color_scale color_scale_dialog::ui_to_scale() const {
  color_scale out;
  for(int x=0;x<items.size();x++) {
    out.add_point(items.at(x)->value(),items.at(x)->color());
  }
  return out;
}

void color_scale_dialog::scale_to_ui() {
  remove_item(items.size());
  QVector <color_scale::point>points = scale.get_points();
  for(int x=0;x<points.size();x++) {
    add_item(points.at(x).c,points.at(x).p);
  }
  ui->range_count_box->setValue(points.size());
}

color_scale_dialog::~color_scale_dialog() {
  delete ui;
}

color_scale_list_item::color_scale_list_item(QWidget *parent) : QWidget(parent) {
  QHBoxLayout *l = new QHBoxLayout;
  l->setAlignment(Qt::AlignLeft);
  setLayout(l);
  btn = new color_button;
  //label = new QLabel;
  num = new QDoubleSpinBox;
  l->addWidget(btn);
  l->addWidget(num);
  connect(btn,&color_button::clicked,this,&color_scale_list_item::button_clicked);
}

void color_scale_list_item::configure(QColor color, double min_value, double max_value, double value) {
  btn->set_color(color);
  num->setRange(min_value,max_value);
  num->setValue(value);
}

void color_scale_list_item::button_clicked() {
  QColorDialog d(color());
  if(d.exec() == QColorDialog::Accepted) {
    btn->set_color(d.selectedColor());
  }
}

void color_scale_dialog::on_range_count_box_valueChanged(int arg1) {
  if(items.size() > arg1) {
    remove_item(items.size() - arg1);
  } else if(items.size() < arg1) {
    add_item(arg1 - items.size());
  }
}

void color_scale_dialog::add_item(int count) {
  for(int x=0;x<count;x++) {
    if(items.isEmpty()) {
      add_item(QColor("#CCCCCC"),0);
    } else {
      add_item(QColor("#CCCCCC"),items.last()->value());
    }
  }
}

void color_scale_dialog::add_item(QColor c, double v) {
  color_scale_list_item *i = new color_scale_list_item;
  if(items.isEmpty()) {
    i->configure(c,-99999999,9999999,v);
  } else {
    i->configure(c,items.last()->value(),9999999,v);
    connect(items.last(),&color_scale_list_item::value_changed,i,&color_scale_list_item::set_min_value);
  }
  items.append(i);
  ui->r_layout->addWidget(i);
}

void color_scale_dialog::remove_item(int count) {
  for(int x=0;x<count;x++) {
    if(items.isEmpty()) return;
    delete items.takeLast();
  }
}

void color_scale_dialog::on_ok_btn_clicked() {
  scale = ui_to_scale();
  accept();
}

void color_scale_dialog::on_cancel_btn_clicked() {
    reject();
}

void color_scale_dialog::on_database_btn_clicked() {
  database_dialog d("COLORSCALE",ui_to_scale().export_data());
  if(d.exec() == database_dialog::Accepted) {
    dbdata data = d.selected_item;
    if(scale.import_data(data) == false) return;
    scale_to_ui();
  }
}

void color_scale_dialog::on_estimate_btn_clicked() {
  double min_value = __DBL_MAX__;
  double max_value = __DBL_MIN__;
  for(int x=0;x<values.size();x++) {
    if(values.at(x) < min_value) min_value = values.at(x);
    if(values.at(x) > max_value) max_value = values.at(x);
  }

  scale.estimate(min_value,max_value);
  scale_to_ui();
}
