#include "module_grapher.h"
#include "ui_module_grapher.h"
#include "../widgets/data_selector_widget.h"
#include "../widgets/surfacegraph.h"

module_grapher::module_grapher(module *parent) :
  module(parent),
  ui(new Ui::module_grapher),
  data(parent->get_data()) {
  ui->setupUi(this);
  set_icon("box_icon&16.png");
  set_name(parent->name() + " 3D Graph");

  graph = new Q3DSurface();

  if(data.table == nullptr) {
    this->deleteLater();
    return;
  }

  if(attach_graph(graph) == false) {
    this->deleteLater();
    return;
  }

  proxy = new QItemModelSurfaceDataProxy(&data);
  proxy->setUseModelCategories(true);

  QSurface3DSeries *series = new QSurface3DSeries(proxy);
  graph->addSeries(series);

  graph->setAspectRatio(1);
  graph->setHorizontalAspectRatio(1);

  attach_graph(graph);

  connect(camera(),&Q3DCamera::zoomLevelChanged,this,&module_grapher::zoom_changed);

  graph->seriesList().at(0)->setDrawMode(QSurface3DSeries::DrawSurfaceAndWireframe);
  set_gradient(Qt::darkGreen, Qt::yellow, Qt::red, Qt::darkRed);

  set_zoom(125);

  connect(data.table,&rftablemodel::data_changed,this,&module_grapher::refresh);
  connect(data.table,&rftablemodel::geometry_changed,this,&module_grapher::refresh);
}

void module_grapher::refresh() {
  graph->removeSeries(series);
  delete series;
  QSurface3DSeries *series = new QSurface3DSeries(proxy);
  graph->addSeries(series);
}

void module_grapher::set_gradient(QColor a, QColor b, QColor c, QColor d) {
  QLinearGradient gr;
  gr.setColorAt(0.0, a);
  gr.setColorAt(0.5, b);
  gr.setColorAt(0.8, c);
  gr.setColorAt(1.0, d);
  graph->seriesList().at(0)->setBaseGradient(gr);
  graph->seriesList().at(0)->setColorStyle(Q3DTheme::ColorStyleRangeGradient);
}

void module_grapher::set_zoom(float zoom) {
  camera()->setZoomLevel(zoom);
}

float module_grapher::get_zoom() {
  return camera()->zoomLevel();
}

module *module_grapher::clone() const {
  return nullptr;
}

bool module_grapher::attach_graph(Q3DSurface *graph) {
  container = QWidget::createWindowContainer(graph,this);
  if (!graph->hasContext()) {
    error("Couldn't initialize the OpenGL context.");
    return false;
  }

  container->setGeometry(this->rect());

  /*
  ui->main_layout->addWidget(container);

  QSize screenSize = graph->screen()->size();
  container->setMinimumSize(QSize(screenSize.width() / 2, screenSize.height() / 1.6));
  container->setMaximumSize(screenSize);
  container->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
  container->setFocusPolicy(Qt::StrongFocus);*/

  return true;
}

rftablemodel *module_grapher::get_data() {
  return data.table;
}

void module_grapher::resizeEvent(QResizeEvent *event) {
  container->setGeometry(this->rect());
  event->accept();
}

module_grapher::~module_grapher() {
  delete ui;
}

QString module_grapher::generate_name() const {
  QString out;
  /*
  out.append(y1axis.name);
  if(y2axis.enabled == true) out.append(" & " + y2axis.name);
  if(xaxis.enabled == true) out.append(" VS " + xaxis.name);
  */
  return out;
}

void module_grapher::zoom_changed(float zoom) {

}
