#ifndef MODULE_2DGRAPHER_H
#define MODULE_2DGRAPHER_H

#include "module.h"
#include "../widgets/qcustomplot.h"

namespace Ui {
class module_grapher2d;
}

class module_grapher2d : public module {
  Q_OBJECT
public:
   module_grapher2d(module *parent);
  _module_type module_type() override { return MODULE_GRAPH; };
  rftablemodel *get_data() override {return nullptr;};

  void invalidate_data();
  void invalidate_time_axis();
  void populate_time_axis();

  dbdata export_data() const;
  bool import_data(const dbdata &in);

  module * clone() const override;

  void move_cursor(double y_value);
  void clear();
public slots:
  void configure();
  void populate_data();
  void source_data_changed();
private slots:
  void on_data_btn_clicked();
  void on_database_btn_clicked();

private:
  rfdatalog *tbl;
  QCustomPlot *plotter;
  QVector<double>keys;
  QMap<QCPGraph*,QString>data_load_cache;
  Ui::module_grapher2d *ui;
  QCPItemLine *cursor = nullptr;
  QString name;
  module *parent_module = nullptr;
};

#endif // MODULE_2DGRAPHER_H
