#include "table_config_dialog.h"
#include "ui_table_config_dialog.h"
#include "database.h"
#include "import_xdf_dialog.h"
#include "database_dialog.h"
#include <QInputDialog>
#include <QApplication>
#include <QClipboard>

table_config_dialog::table_config_dialog(QVector <rfdatalog*>logs) :
  QDialog(nullptr),
  ui(new Ui::table_config_dialog) {

  ui->setupUi(this);

  this->logs = logs;

  if(logs.isEmpty() == false) {
    QStringList common = rfdatalog::common_columns(logs);
    ui->xaxis_data_btn->set_columns(common);
    ui->yaxis_data_btn->set_columns(common);
  }

  ui->autosize_btn->setHidden(logs.isEmpty());
  //ui->xaxis_data_btn->setHidden(simple_mode);
  //ui->yaxis_data_btn->setHidden(simple_mode);

  update_ui();

  connect(ui->xaxis_data_btn,&column_button::changed,this,&table_config_dialog::update_ui);
  connect(ui->yaxis_data_btn,&column_button::changed,this,&table_config_dialog::update_ui);

  connect(ui->xaxis_config,&axis_configurator_widget::changed,this,&table_config_dialog::update_ui);
  connect(ui->yaxis_config,&axis_configurator_widget::changed,this,&table_config_dialog::update_ui);
  connect(ui->table3d_chkbox,&QPushButton::toggled,this,&table_config_dialog::update_ui);
}

void table_config_dialog::update_ui() {
  bool data_valid = true;
  bool numbers_valid = true;
  bool table3d = ui->table3d_chkbox->isChecked();
  bool simple_mode = logs.isEmpty();

  if(simple_mode == false && ui->yaxis_data_btn->is_valid() == false) data_valid = false;
  if(ui->yaxis_config->is_valid() == false) numbers_valid = false;

  if(table3d == true) {
    if(simple_mode == false && ui->xaxis_data_btn->is_valid() == false) data_valid = false;
    if(ui->xaxis_config->is_valid() == false) numbers_valid = false;
  }

  ui->x_group->setHidden(!table3d);

  ui->swap_btn->setEnabled(table3d && data_valid && numbers_valid);
  ui->ok_btn->setEnabled(data_valid && numbers_valid);
  ui->autosize_btn->setEnabled(data_valid);
}

void table_config_dialog::on_cancel_btn_clicked() {
  reject();
}

void table_config_dialog::on_ok_btn_clicked() {
  accept();
}

void table_config_dialog::on_autosize_btn_clicked() {
  autoconfig_column(ui->xaxis_data_btn,ui->xaxis_config);
  autoconfig_column(ui->yaxis_data_btn,ui->yaxis_config);
}

void table_config_dialog::autoconfig_column(column_button *c, axis_configurator_widget *w) {
  if(logs.isEmpty()) return;
  if(c->is_valid() == false) return;

  double max = __DBL_MIN__;
  double min = __DBL_MAX__;

  for(int log=0;log<logs.size();log++) {
    int idx = logs.at(log)->col_index(c->col_name);
    for(int x=0;x<logs.at(log)->n_rows();x++) {
      double d = logs.at(log)->double_at(x,idx);
      if(d > max) max = d;
      if(d < min) min = d;
    }
  }
  w->autofill(min,max,17);
}

table_axis table_config_dialog::get_xaxis() const {
  if(ui->table3d_chkbox->isChecked() == false) return table_axis(); // return invalid axis in 2d mode.
  table_axis out = ui->xaxis_config->generate_axis();
  out.name = ui->xaxis_data_btn->col_name;
  return out;
}

table_axis table_config_dialog::get_yaxis() const {
  table_axis out = ui->yaxis_config->generate_axis();
  out.name = ui->yaxis_data_btn->col_name;
  return out;
}

void table_config_dialog::configure(table_axis xaxis, table_axis yaxis) {
  ui->xaxis_config->load_axis(xaxis);
  ui->yaxis_config->load_axis(yaxis);
  ui->xaxis_data_btn->set_column(xaxis.name);
  ui->yaxis_data_btn->set_column(yaxis.name);
  if(yaxis.is_valid() && ! xaxis.is_valid()) {
    ui->table3d_chkbox->setChecked(false);
  } else {
    ui->table3d_chkbox->setChecked(true);
  }
  update_ui();
}

bool table_config_dialog::is_2d() const {
  return ! is_3d();
}

bool table_config_dialog::is_3d() const {
  return ui->table3d_chkbox->isChecked();
}

void table_config_dialog::on_swap_btn_clicked() {
  {
    table_axis tmp = ui->yaxis_config->generate_axis();
    ui->yaxis_config->load_axis(ui->xaxis_config->generate_axis());
    ui->xaxis_config->load_axis(tmp);
  }
  {
    QString tmp = ui->yaxis_data_btn->col_name;
    ui->yaxis_data_btn->set_column(ui->xaxis_data_btn->col_name);
    ui->xaxis_data_btn->set_column(tmp);
  }
  update_ui();
}

void table_config_dialog::on_xdf_btn_clicked() {
  import_xdf_dialog d;
  if(d.exec() == import_xdf_dialog::Accepted) {
    configure(d.selected_table.x,d.selected_table.y);
  }
}

void table_config_dialog::on_database_btn_clicked() {
  table_geometry g;
  g.x = ui->xaxis_config->generate_axis();
  g.y = ui->yaxis_config->generate_axis();
  g.x.name = ui->xaxis_data_btn->col_name;
  g.y.name = ui->yaxis_data_btn->col_name;
  g.id = -1;
  dbdata db_out = g.export_data();
  database_dialog dialog("GEOMETRY",db_out);
  if(dialog.exec() == database_dialog::Accepted) {
    table_geometry t;
    t.import_data(dialog.selected_item);
    ui->xaxis_config->load_axis(t.x);
    ui->yaxis_config->load_axis(t.y);
    ui->xaxis_data_btn->set_column(t.x.name);
    ui->yaxis_data_btn->set_column(t.y.name);
    ui->table3d_chkbox->setChecked(t.is_3d());
  }
}

void table_config_dialog::on_romraider_btn_clicked() {
  QStringList lines = QApplication::clipboard()->text().split('\n',Qt::SkipEmptyParts);

  // bail if wrong format.
  if(lines.startsWith("[Table3D]")) {
    lines.takeFirst();
  } else {
    return;
  }

  if(lines.isEmpty()) return;
  QStringList columns = lines.takeFirst().split('\t');

  QStringList rows;
  while(lines.isEmpty() == false) {
    QString in = lines.takeFirst();
    QStringList x = in.split('\t');
    if(x.isEmpty()) return;
    rows.append(x.at(0));
  }

  ui->xaxis_config->load_axis(columns);
  ui->yaxis_config->load_axis(rows);
}
