#ifndef ANALYSIS_H
#define ANALYSIS_H

#include <QString>
#include <QVector>
#include <QAbstractTableModel>
#include "rfdatalog.h"
#include "rftablemodel.h"
#include "table_geometry.h"
#include "regression.h"
#include "afilter.h"

class a_cell {
public:
  void add_data(const double &value);
  void set_static_data(const double &value, const double &count, const double &min, const double &max);
  double min = 0;
  double max = 0;
  double avgsum = 0;
  double calculated = 0;
  double avg() const;
  int count = 0;
  bool static_avg = false;
  void set_null();
};

class rfanalysis : public rftablemodel {
public:
  rfanalysis();
  rfanalysis(const rfanalysis &other);

  _table_type table_type() const override;

  double lagfilter = 0.00;
  int mincount = 0;

  bool is_valid() const;
  bool set_equation(const QString &equation);

  int n_columns() const override;
  int n_rows() const override;
  bool is_null(const int &row, const int &col) const override;

  QString col_name(const int &col) const override;
  QString row_name(const int &row) const override;

  QString x_axis_name() const override { return xaxis.name; };
  QString y_axis_name() const override { return yaxis.name; };

  double double_at(const int &row, const int &col) const override;
  QString string_at(const int &row, const int &col) const override;

  bool set_layout(const table_axis &xaxis, const table_axis &yaxis);
  bool set_data_col(const QString &data_col);
  bool set_filters(const QVector<afilter> &filters);
  QVector <afilter>get_filters() const;
  int n_filters() const { return filters.size(); };

  enum display_t {
    DISPLAY_MIN,
    DISPLAY_MAX,
    DISPLAY_AVG,
    DISPLAY_COUNT,
    DISPLAY_CALC
  };
  display_t display = DISPLAY_AVG;

  enum _analysis_method {
    BILINEAR = 0,
    NEAREST_NEIGHBOUR = 1,
    XLINEAR = 2,
    YLINEAR = 3,
    LEFTALIGN = 4,
    RIGHTALIGN = 5,
    UNDEFINED
  };

  double max_value() const override;
  double min_value() const override;

  void set_view(const QString &view) override;
  QString current_view() const override;
  QStringList get_views() const override;

  void clear_data();
  void analyze(QVector<rfdatalog *> logs);
  QString data_col() const { return _data_col; };

  //------------

  table_axis x_axis() const override;
  double x_axis_value(const int &col) const override;
  table_axis y_axis() const override;
  double y_axis_value(const int &row) const override;

  double _min_value = __DBL_MAX__;
  double _max_value = __DBL_MIN__;

  void change_display(display_t d);
  bool test_filters(rftablemodel *log, const int &row) const;

  bool refactor(rfdatalog *log);

  QStringList errors;

  bool filter_edges = false;
  _analysis_method method = NEAREST_NEIGHBOUR;

  void testing();

  dbdata export_data() const;
  bool import_data(const dbdata &data);

  QString get_equation() const;

private:
  QVector <afilter>filters;
  QVector <QVector<a_cell>>table; // [x][y]
  void analyze_3d_standard(rfdatalog *log, table_axis::_locate_alignment alignment);
  void analyze_2d_standard(rfdatalog *log);
  table_axis xaxis;
  table_axis yaxis;
  QString _data_col;

  void analyze_3d_linear(rfdatalog *log, bool filter_edges, regression_table::_analysis_mode mode);
  void analyze_2d_linear(rfdatalog *log, bool filter_edges);

  QString equation;
  void recalculate();
};

#endif // ANALYSIS_H
