#include "chart_element_dialog.h"
#include "ui_chart_element_dialog.h"
#include <QVector>
#include "modules/module_grapher2d.h"

chart_element_dialog::chart_element_dialog(QCustomPlot *plot, rfdatalog *log, QWidget *parent) :
  QDialog(parent),
  ui(new Ui::chart_element_dialog) {

  ui->setupUi(this);

  this->log = log;
  this->plot = plot;

  for(int x=0;x<plot->graphCount();x++) {
    chart_config_item *i = new chart_config_item(plot->graph(x),log);
    items.append(i);
    connect(i,&chart_config_item::item_delete_request,this,&chart_element_dialog::delete_requested);
    ui->element_layout->addWidget(i);
  }

}

chart_element_dialog::~chart_element_dialog() {
  delete ui;
}

void chart_element_dialog::on_ok_btn_clicked() {
  accept();
}

void chart_element_dialog::delete_requested(chart_config_item *i) {
  plot->removeGraph(i->graph);
  plot->axisRect()->removeAxis(i->axis);
  delete i;
}

void chart_element_dialog::on_add_btn_clicked() {
  QCPGraph *graph = plot->addGraph(plot->xAxis,plot->axisRect()->addAxis(QCPAxis::atLeft));
  chart_config_item *i = new chart_config_item(graph,log);
  if(items.isEmpty() == false) {
    i->set_color(items.last()->selected_color_index());
    i->next_color();
  }
  items.append(i);
  connect(i,&chart_config_item::item_delete_request,this,&chart_element_dialog::delete_requested);
  ui->element_layout->addWidget(i);
}
