#include "module_datalog.h"
#include "ui_module_datalog.h"

module_datalog::module_datalog(rfdatalog *data_in, const QString &name) :
  module(nullptr),
  ui(new Ui::module_datalog) {
  ui->setupUi(this);
  data = data_in;
  ui->renderer->set_data(data);
  set_name(name);
  set_icon("document_icon&16.png");
}

module_datalog::~module_datalog() {
  if(data != nullptr) delete data;
  delete ui;
}

rftablemodel *module_datalog::get_data() {
  return data;
}

module *module_datalog::clone() const {
  // it makes really no sense to clone a datalog....since we can't edit it,but whatever.
  // clone the data too.
  rfdatalog *d = new rfdatalog(*data);
  module_datalog *out = new module_datalog(d,name() + " Copy");
  return out;
}
