#ifndef DYNAMIC_COLUMN_H
#define DYNAMIC_COLUMN_H

class rfdatalog;

#include "../muparser/include/muParser.h"

#include <QVector>
#include "rftable.h"

class dynamic_col_variable {
public:
  dynamic_col_variable() {};
  dynamic_col_variable(const dynamic_col_variable &other);
  dynamic_col_variable operator =(const dynamic_col_variable &other);

  QStringList sources;
  enum _col_type_t {
    COL_DIRECT,
    COL_LOOKUP
  };
  _col_type_t col_type = COL_DIRECT;
  bool is_compatible(rfdatalog *log) const;
  double value(rfdatalog *log, const int &row) const;
  QString display_name() const;
  ~dynamic_col_variable();
  rftable lookup;
  rflookupconfig lookup_config;

  dbdata export_data() const;
  bool import_data(const dbdata &data);


private:
  rfdatalog *last_log = nullptr;
  mutable QVector <int>src_cache;
};

class dynamic_column {
public:
  QString name;
  int id = -1;
  int revision = 0;

  bool is_compatible(rfdatalog *log) const;
  bool uses_math() const;
  QString equation;

  void set_equation(QString equation);
  void add_col_variable(const QString &col_name);
  void add_lookup_variable(const rftable &table, const rflookupconfig &config);
  void delete_variable(int index);

  dynamic_col_variable variable_at(int x) const;
  int variable_count() const;

  dynamic_col_variable col_at(int x) const;
  int count() const;
  bool reload_calculator();

  double value(rfdatalog *log, const int &row) const;
  QVector <dynamic_col_variable>variables;

  QString equation_errors;

  static QString var_name(int index);

  dbdata export_data() const;
  bool import_data(const dbdata &data);

  void edit_lookup_variable(int index, const rftable &table, const rflookupconfig &config);
  void edit_col_variable(int index, const QString &col_name);
private:
  mu::Parser calc;
  mutable QVector <double>var_storage;
};

class dynamic_column_list : public QVector<dynamic_column> {
public:
  dynamic_column *ptr(int i);
  dbdata export_data() const;
  bool import_data(const dbdata &data);

private:

};

#endif // DYNAMIC_COLUMN_H
