#ifndef RFCOMPARETABLE_H
#define RFCOMPARETABLE_H

#include "rftablemodel.h"
#include "muparser/include/muParser.h"

class rfmathtable : public rftablemodel {
public:
  enum interp_type_t {
    INTERP_LINEAR,
    INTERP_NEIGHBOUR
  };

  rfmathtable(QVector <rftablemodel*>tables);

  bool set_equation(const QString &eq);

  double double_at(const int &row, const int &col) const override;
  QString string_at(const int &row, const int &col) const override;
  bool is_null(const int &row, const int &col) const override;

  bool valid() const override;

  _table_type table_type() const override;

  void set_view(const QString &view) override;

  table_axis x_axis() const override;
  table_axis y_axis() const override;

  bool readonly() const override;

  bool auto_col_size() const override;

  QString col_name(const int &col) const override;
  QString row_name(const int &row) const override;

  int n_columns() const override;;
  int n_rows() const override { return yaxis.count(); };
  void set_null_filter(bool enable);
  void set_interp_type(interp_type_t t);

  QStringList errors;

  void copy_layout(rftablemodel *m);

  QStringList get_labels() const;
  void copy_layout(int index);

public slots:
  void set_layout(table_geometry g);
  void parent_data_changed();

private: 
  QVector <rftablemodel*>tables;
  QVector <QChar>table_symbols;
  mutable QVector <double>table_data;
  mutable double X,Y;

  table_axis xaxis;
  table_axis yaxis;

  double lookup(double x, double y, rftablemodel *m) const;

  interp_type_t interp_type = INTERP_LINEAR;

  bool filter_null = true;
  bool equation_valid = false;

  mu::Parser calc;
};


#endif // RFCOMPARETABLE_H
