#ifndef DYNAMIC_COL_DIALOG_H
#define DYNAMIC_COL_DIALOG_H

#include <QDialog>
#include "../datastructures/dynamic_column.h"

class rftablewidget;
class module_table;
class lookup_config_widget;

namespace Ui {
class dynamic_col_dialog;
}

class table_dialog : public QDialog {
  Q_OBJECT
public:
  table_dialog(QVector <rfdatalog*>logs, rftable *tbl, rflookupconfig conf);
  module_table *table_editor;
  rftable table;
  rflookupconfig lookup_config;
public slots:
  void table_modified();
  void finalize();
private:
  QVector <rfdatalog*>logs;
  QPushButton *ok_btn = nullptr;
  lookup_config_widget *lookup_widget;
};

class dynamic_col_dialog : public QDialog {
  Q_OBJECT

public:
  dynamic_col_dialog(QVector <rfdatalog*>logs, dynamic_column_list *dyn, QWidget *parent = nullptr);
  ~dynamic_col_dialog();

  void render_column();
  void render_list();
  dynamic_column *current_column();

  void refresh_var_names();

private slots:
  void on_add_column_btn_clicked();
  void on_add_lookup_btn_clicked();
  void on_edit_btn_clicked();
  void on_delete_btn_2_clicked();
  void on_var_list_itemSelectionChanged();
  void on_col_list_itemSelectionChanged();
  void on_add_btn_clicked();
  void on_delete_btn_clicked();
  void on_equation_box_textChanged(const QString &arg1);
  void on_save_btn_clicked();
  void on_cancel_btn_clicked();

private:
  Ui::dynamic_col_dialog *ui;
  QStringList available_columns;
  dynamic_column_list *dyn;
  QVector <rfdatalog*>logs;
  void refresh_equation();
};

#endif // DYNAMIC_COL_DIALOG_H
