#ifndef AXIS_STORAGE_H
#define AXIS_STORAGE_H

#include <QSettings>
#include <QSqlQuery>
#include <QHash>

class dbitem {
public:
  QString name;
  int id;
  QString data;
  QString table_name;
};

class dbdata : public dbitem {
public:
  bool is_valid() const;
  bool from_string(const QString &data_in, const QString &table_name);
  QString to_string(const QString &table_name) const;
  QVariant value(const QString &key, const QVariant &default_value = QVariant()) const;
  void set(const QString &key, const QVariant &value);
  void set_subdata(const QString &key, const dbdata &value);
  dbdata subdata(const QString &key) const;
  void clear();
  QStringList parameter_list() const;
  QByteArray to_sub() const;
  bool from_sub(const QByteArray &b);
private:
  QMap <QString,QVariant>data;
  bool valid = false;
};

class database {
public:
  database();
  static bool init();
  static bool configure_db();

  static bool set_config(const QString &key, const QVariant &data);
  static QVariant get_config(const QString &key, const QVariant &default_value = QVariant());

  static QVector<dbitem> list(const QString &table_name);
  static dbdata data(const QString &table_name, const int &id);
  static int insert(const QString &table_name, const dbdata &all_data);
  static int replace(const QString &table_name, const dbdata &all_data);
  static int remove(const QString &table_name, int id);

  static void err(const QString &err_msg);
  static void err(const QSqlQuery &q);

  static QString ascii_query(const QString &query);
  static QString ascii_table(QSqlQuery &q);

  static QSqlDatabase *db_instance() {return &db;};

  static QVector<dbitem> profile_list();
  static int save_profile(const dbitem &p); // returns ID

  static bool upgrade_db(int old_version);

  static bool change_profile(int profile_id);
  static QString profile_name();

  static QVector<dbdata> all_data(const QString &table_name);
  static int drop(const QString &table_name, const dbdata &all_data);

private:
  static QSqlDatabase db;
  static bool create_db(bool upgrade = false);
  static int profile_id;
  static QString _profile_name;
  static bool create_std_table(const QString &table_name);
};

#endif // AXIS_STORAGE_H
