#ifndef SQLTABLE_H
#define SQLTABLE_H

#include "rftablemodel.h"
#include <QSqlQuery>

class rfsqltable : public rftablemodel {
public:
  rfsqltable(const QString &table_name);
  rfsqltable(QSqlQuery &q);

  _table_type table_type() const override { return DATALOG; };

  int n_columns() const override;
  int n_rows() const override;
  QString col_name(const int &col) const override;
  QString row_name(const int &row) const override;
  QString string_at(const int &row, const int &col) const override;
  int data_index(const int &row, const int &col) const;
  bool valid() const override {return _valid;};
  void load_table(QSqlQuery &q);

private:
  QStringList data;
  QStringList header;
  int _n_cols = 0;
  int _n_rows = 0;
  bool _valid = false;
};

#endif // SQLTABLE_H
