#ifndef USERTABLE_H
#define USERTABLE_H

#include "rftablemodel.h"
#include "table_geometry.h"

class rftable : public rftablemodel {
public:
  rftable();
  rftable(const rftable &other);
  rftable(const rftablemodel &other);

  enum _layout_handler {
    INTERPOLATE,
    CLEAR_ALL,
    CLEAR_NONMATCHING,
    OVERWRITE
  };

  table_axis x_axis() const override;
  table_axis y_axis() const override;
  QString x_axis_name() const override { return xaxis.name; };
  QString y_axis_name() const override { return yaxis.name; };

  _table_type table_type() const override {
    if(xaxis.values.isEmpty() == true) return TABLE2D;
    return TABLE3D;
  };

  void set_layout(table_axis xaxis, table_axis yaxis, _layout_handler handler = CLEAR_ALL, table_interpolation config = table_interpolation());

  int n_columns() const override;
  int n_rows() const override;
  bool is_null(const int &row, const int &col) const override;
  QString col_name(const int &col) const override;
  QString row_name(const int &row) const override;
  QString string_at(const int &row, const int &col) const override;
  double double_at(const int &row, const int &col) const override;
  bool set(const double &d, const int &row, const int &col) override;
  bool set(const QString &s, const int &row, const int &col) override;
  bool set_null(const int &row, const int &col) override;
  bool in_bounds(const int &row, const int &col) const;
  bool readonly() const override { return false; };

  bool contains_data() const;
  bool data_complete() const;

  void resize();
  void clear();

  int data_index(const int &row, const int &col) const;

  bool layout_is_identical(const rftablemodel &other);
  void interpolate_3d(table_axis xaxis, table_axis yaxis, table_interpolation config);

  bool copy_layout(const rftablemodel &other);
  bool copy_data(const rftablemodel &other);

  dbdata export_data() const;
  bool import_data(const dbdata &data);

private:
  QVector <double>data;
  QVector <QVector<double>>snapshots;
  int snapshot_ptr = -1;
  QVector <bool>data_null;
  table_axis xaxis;
  table_axis yaxis;
};

#endif // USERTABLE_H
