#ifndef AXIS_H
#define AXIS_H

#include <QVector>
#include <QString>
#include <QDebug>

#include "database.h"

class dbdata;

class table_cell {
public:
  table_cell(const int &row, const int &col) {this->col = col;this->row = row;};
  table_cell();
  int col;
  int row;
  bool operator ==(const table_cell &other) const { return col == other.col && row == other.row; };
};

class table_region {
public:
  table_region() {};
  table_region(const int &row, const int &col, const int height = 1, const int width = 1) {
    this->row = row; this->col = col; this->width = width; this->height = height;
  }
  int row = 0;
  int col = 0;
  int width = 1;
  int height = 1;
  bool contains(const int &row, const int &col) const;
  QVector <table_cell>cells() const;
  int count() const {return width * height;};
};

class table_axis {
public:
  void copy(const table_axis &a);
  table_axis() {};
  table_axis(const table_axis &other) {copy(other);};
  table_axis(const QVector <double>&values, const QString name = QString(), const int precision = -1) {
    this->values = values; this->_precision = precision; this->name = name;
  };
  bool operator==(const table_axis& other);
  table_axis& operator=(const table_axis &other) {copy(other); return *this;};

  // 10 20 30 40 50
  //   12

  enum _locate_alignment {
    ALIGN_LH, // for the set 10,20,30 and the data point 12, result would be 0.
    ALIGH_RH, // for the set 10,20,30 and the data point 12, result would be 1.
    ALIGN_NN  // nearest neighbour.  for the set 10,20,30 and the data point 12, the result would be 0.  for the data point 18, it would be 1.
  };

  int locate_index(const double &value, _locate_alignment align = table_axis::ALIGN_NN) const;
  bool value_in_range(const double &value) const;

  QString name;

  bool is_valid() const;
  void clear();

  double at(int i) const;
  int count() const;
  int precision() const;
  double interval() const;

  QVector<double>values;

  QString encode_values() const;
  bool decode_values(const QString &s);

  bool is_sequential() const;

  void calc_precision();
  int _precision = -1;
};

class table_geometry {
public:
  QString dbname;
  int id = -1;
  table_axis x;
  table_axis y;
  bool is_2d() const {return x.is_valid() == false;};
  bool is_3d() const {return x.is_valid() == true;};
  bool is_valid() const {return y.is_valid() && (x.is_valid() || x.values.isEmpty());};
  bool hidden = false;
  QString size_string() const;
  void clear();
  dbdata export_data() const;
  bool import_data(const dbdata &data);
private:
};

class table_interpolation {
public:
  enum _interp_method {
    LINEAR,
    SPLINE,
    NEIGHBOUR
  };
  _interp_method method;
  enum _tail_method {
    CONTINUE,
    ZERO
  };
  _tail_method tail;
};



#endif // AXIS_H
