#ifndef COLOR_SCALE_DIALOG_H
#define COLOR_SCALE_DIALOG_H

#include <QDialog>
#include "../widgets/rftablewidget.h"
#include <QDoubleSpinBox>
#include <QLabel>
#include "../widgets/color_button.h"

namespace Ui {
class color_scale_dialog;
}

class color_scale_list_item : public QWidget {
  Q_OBJECT
public:
  color_scale_list_item(QWidget *parent = nullptr);
  void configure(QColor color, double min_value, double max_value, double value);
  color_button *btn;
  QDoubleSpinBox *num;
  QLabel *label;
  double value() const { return num->value();};
  QColor color() const { return btn->get_color();};

signals:
  void value_changed(double value);

public slots:
  void set_min_value(double value) {num->setMinimum(value);};
  void set_max_value(double value) {num->setMaximum(value);};
  void button_clicked();
};

class color_scale_dialog : public QDialog {
  Q_OBJECT

public:
  explicit color_scale_dialog(color_scale scale, QVector <double>values, QWidget *parent = nullptr);
  ~color_scale_dialog();
  color_scale scale;

  void scale_to_ui();
private slots:
  void on_range_count_box_valueChanged(int arg1);
  void on_ok_btn_clicked();
  void on_cancel_btn_clicked();
  void on_database_btn_clicked();

  void on_estimate_btn_clicked();

private:
  Ui::color_scale_dialog *ui;
  QVector <color_scale_list_item*>items;
  void add_item(int count);
  void add_item(QColor c, double v);
  void remove_item(int count);
  color_scale ui_to_scale() const;
  QVector <double>values;
};

#endif // COLOR_SCALE_DIALOG_H
