#ifndef MODULE_COMPARE_H
#define MODULE_COMPARE_H

#include <QWidget>
#include "module.h"
#include "../datastructures/rfmathtable.h"

namespace Ui {
class module_compare;
}

class module_compare : public module {
  Q_OBJECT

public:
  module_compare(QVector<module *> modules);
  ~module_compare();
  rftablemodel * get_data() override { return tbl; };
  _module_type module_type() override { return MODULE_TABLE; };

  module * clone() const override;

  QString get_equation() const;
  bool set_equation(const QString &eq);

private slots:
  void on_layout_btn_clicked();
  void on_linear_btn_toggled(bool checked);
  void on_neighbour_btn_toggled(bool checked);
  void on_range_btn_toggled(bool checked);
  void on_calc_entry_editingFinished();
  void layout_button_clicked();

private:
  Ui::module_compare *ui;
  rfmathtable *tbl;
  QStringList table_names;
  QMap <QPushButton*,int>button_map;
  QVector <module*>modules;
};

#endif // MODULE_COMPARE_H
