#include "data_selector_widget.h"
#include "ui_data_selector_widget.h"
#include <QInputDialog>
#include <QKeyEvent>
#include <QDialog>

data_selector_widget::data_selector_widget(const QString name, const QStringList &values, QWidget *parent) :
  QDialog(parent),
  ui(new Ui::data_selector_widget) {
  ui->setupUi(this);
  setWindowTitle(name);
  ui->element_list->addItems(values);
  ui->ok_btn->setEnabled(false);
}

data_selector_widget::~data_selector_widget() {
  delete ui;
}

void data_selector_widget::on_element_search_textEdited(const QString &arg1) {
  QStringList search_terms = arg1.split(' ',Qt::SkipEmptyParts);
  int count = ui->element_list->count();
  bool first = false;
  ui->element_list->clearSelection();
  for(int x=0;x<count;x++) {
    QListWidgetItem *i = ui->element_list->item(x);
    i->setHidden(! matches_search(search_terms,i->text()));
    if(first == false && i->isHidden() == false) {//select first item
      i->setSelected(true);
      first = true;
    }
  }
}

bool data_selector_widget::matches_search(const QStringList &search, const QString &text) {
  if(search.isEmpty()) return true;
  for(int y=0;y<search.size();y++) {
    if(text.contains(search.at(y),Qt::CaseInsensitive) == false) {
      return false;
    }
  }
  return true;
}

void data_selector_widget::on_cancel_btn_clicked() {
   reject();
}

void data_selector_widget::on_ok_btn_clicked() {
  if(selected_element.isEmpty() == true || selected_index == -1) return;
   accept();
}

void data_selector_widget::on_element_list_itemSelectionChanged() {
  QList <QListWidgetItem*>items = ui->element_list->selectedItems();
  if(items.size() == 1) {
    selected_element = items.at(0)->text();
    selected_index = ui->element_list->row(items.at(0));
    ui->ok_btn->setEnabled(true);
  } else {
    selected_element.clear();
    selected_index = -1;
    ui->ok_btn->setEnabled(false);
  }
}

void data_selector_widget::on_element_list_itemDoubleClicked(QListWidgetItem *item) {
   selected_element = item->text();
   accept();
}

column_button::column_button(QWidget *parent) : QPushButton(parent){
  setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Fixed);
  connect(this,&QPushButton::clicked,this,&column_button::popup);
  update_text();
}

bool column_button::is_valid() const {
  if(col_name.isEmpty() && ! cols.isEmpty()) return false;
  return true;
}

void column_button::set_column(const QString &col_name) {
  this->col_name = col_name;
  update_text();
  emit column_selected(col_name);
  emit changed();
}

void column_button::popup() {
  if(cols.isEmpty()) {
    QString s = QInputDialog::getText(nullptr,"Axis Name","Enter name for axis.",QLineEdit::Normal,col_name);
    if(s.isEmpty() == false) set_column(s);
  } else {
    data_selector_widget d("Select Log Column",cols);
    if(d.exec() == data_selector_widget::Accepted) set_column(d.selected_element);
  }
}

void column_button::set_columns(rftablemodel *d) {
  set_columns(d->column_string_list());
}

void column_button::set_columns(const QStringList &s) {
  cols = s;
  update_text();
  emit changed();
}

void column_button::update_text() {
  if(cols.isEmpty()) {
    setIcon(QIcon());
    if(col_name.isEmpty()) {
      setText("Rename axis...");
    } else {
      setText(col_name);
    }
  } else {
    if(is_valid() == false) {
      setText("Select Data...");
      setIcon(QIcon(":/graphics/cc_16/star_icon&16.png"));
    } else {
      setText(col_name);
      if(cols.contains(col_name)) {
        setIcon(QIcon(":/graphics/cc_16/checkmark_icon&16.png"));
      } else {
        setIcon(QIcon(":/graphics/cc_16/attention_icon&16.png"));
      }
    }
  }
}
