#include "database_dialog.h"
#include "ui_database_dialog.h"
#include "database.h"
#include <QInputDialog>
#include <QClipboard>

database_dialog::database_dialog(const QString &table_name, const dbdata &original_item, QWidget *parent) :
  QDialog(parent),
  ui(new Ui::database_dialog) {
  ui->setupUi(this);

  this->table_name = table_name;
  setWindowTitle(table_name);

  reload_contents();

  this->original_item = original_item;
  this->original_item.table_name = table_name;

  ui->load_btn->setEnabled(false);
  ui->delete_btn->setEnabled(false);

  if(original_item.is_valid()) {
    for(int x=0;x<data.size();x++) {
      if(data.at(x).id == original_item.id) ui->db_list->item(x)->setSelected(true);
    }
    ui->copy_btn->setEnabled(true);
  } else {
    ui->save_btn->setEnabled(false);
    ui->replace_btn->setEnabled(false);
    ui->copy_btn->setEnabled(false);
  }
}

void database_dialog::reload_contents() {
  ui->db_list->clear();
  data = database::all_data(table_name);
  for(int x=0;x<data.size();x++) {
    ui->db_list->addItem(data.at(x).name);
  }
}

database_dialog::~database_dialog() {
  delete ui;
}

bool database_dialog::matches_search(const QStringList &search, const QString &text) {
  if(search.isEmpty()) return true;
  for(int y=0;y<search.size();y++) {
    if(text.contains(search.at(y),Qt::CaseInsensitive) == false) {
      return false;
    }
  }
  return true;
}

void database_dialog::on_text_entry_textEdited(const QString &arg1) {
  QStringList search_terms = arg1.split(' ',Qt::SkipEmptyParts);
  int count = ui->db_list->count();
  bool first = false;
  ui->db_list->clearSelection();
  for(int x=0;x<count;x++) {
    QListWidgetItem *i = ui->db_list->item(x);
    i->setHidden(! matches_search(search_terms,i->text()));
    if(first == false && i->isHidden() == false) {//select first item
      i->setSelected(true);
      first = true;
    }
  }
}

void database_dialog::on_load_btn_clicked() {
  QList <QListWidgetItem*>selection = ui->db_list->selectedItems();
  if(selection.isEmpty()) {
    selected_item.clear();
  } else {
    selected_item = data.at(ui->db_list->row(selection.at(0)));
  }
  accept();
}

void database_dialog::on_save_btn_clicked() {
  QString name = original_item.name;
  if(name.isEmpty() && ui->text_entry->text().isEmpty() == false) name = ui->text_entry->text();
  QString s = QInputDialog::getText(nullptr,"Database name","Enter name:",QLineEdit::Normal,name);
  if(s.isEmpty()) return;
  selected_item = original_item;
  selected_item.table_name = table_name;
  selected_item.name = s;
  selected_item.id = database::insert(table_name,selected_item);
  accept();
}

void database_dialog::on_replace_btn_clicked() {
  QList <QListWidgetItem*>selection = ui->db_list->selectedItems();
  if(selection.size() != 1) return;
  int id = data.at(ui->db_list->row(selection.at(0))).id;
  selected_item = original_item;
  selected_item.table_name = table_name;
  selected_item.id = id;
  database::replace(table_name,selected_item);
  accept();
}

void database_dialog::on_db_list_itemSelectionChanged() {
  QList <QListWidgetItem*>selection = ui->db_list->selectedItems();
  ui->load_btn->setEnabled(!selection.isEmpty());
  ui->delete_btn->setEnabled(!selection.isEmpty());
  ui->replace_btn->setEnabled(!selection.isEmpty() && original_item.is_valid());
  ui->copy_btn->setEnabled(!selection.isEmpty() || original_item.is_valid());
}

void database_dialog::on_delete_btn_clicked() {
  QList <QListWidgetItem*>selection = ui->db_list->selectedItems();
  if(selection.size() != 1) return;
  database::drop(table_name,data.at(ui->db_list->row(selection.at(0))));
  reload_contents();
}

void database_dialog::on_cancel_btn_clicked() {
  reject();
}

void database_dialog::on_db_list_itemDoubleClicked(QListWidgetItem *item) {
  selected_item = data.at(ui->db_list->row(item));
  accept();
}

void database_dialog::on_copy_btn_clicked() {
  QString out;
  if(selected_item.is_valid() == false) {
    out = original_item.to_string(table_name);
  } else {
    out = selected_item.to_string(table_name);
  }
  for(int x=0;x<out.length();x+=40) {
    out.insert(x,'\n');
  }
  QApplication::clipboard()->setText(out);
  reject();
}

void database_dialog::on_paste_btn_clicked() {
  QString in = QApplication::clipboard()->text();
  in.remove('\n');
  dbdata d;
  if(d.from_string(in,table_name) == true) {
    selected_item = d;
    accept();
  }
}
