#include "module.h"
#include <QDebug>
#include <QMessageBox>



unsigned int module::last_id = 10;

module::module(QWidget *parent) : QWidget(parent) {
  assign_id();
  listwidget = new QListWidgetItem;
  listwidget->setData(Qt::UserRole,id());
  set_name(QString());
}

module::~module() {
  delete listwidget;
}

QString module::name() const {
  return listwidget->text();
}

void module::set_name(const QString &s) {
  if(s.isEmpty()) {
    listwidget->setText("Not Configured.");
    emit name_changed("Not Configured.");
  } else {
    listwidget->setText(s);
    emit name_changed(s);
  }
}

void module::set_icon(const QString &s) {
  listwidget->setIcon(QIcon(":/graphics/cc_16/" + s));
}

QIcon module::get_icon() const {
  return listwidget->icon();
}

void module::error(const QString &err_msg) {
  QMessageBox::warning(nullptr,"Error",err_msg);
}

void module::assign_id() {
  if(_id == 0) {
    last_id++;
    _id = last_id;
  }
}

void module::add_child(int module_id) {
  if(_children.contains(module_id) == false) {
    _children.append(module_id);
  }
}

void module::add_child(module *m) {
  add_child(m->id());
}

void module::remove_child(int module_id) {
  _children.remove(module_id);
}

void module::copy_children(module *m) {
  _children.append(m->children());
}
