#include "module_compare.h"
#include "ui_module_compare.h"

#include "../dialogs/table_config_dialog.h"

module_compare::module_compare(QVector <module*>modules) :
  module(nullptr),
  ui(new Ui::module_compare) {
  ui->setupUi(this);

  this->modules = modules;

  QVector <rftablemodel*>tables;
  for(int x=0;x<modules.size();x++) {
    tables.append(modules.at(x)->get_data());
    table_names.append(modules.at(x)->name());
  }

  tbl = new rfmathtable(tables);
  set_name(table_names.join(" vs "));

  ui->eq_err->setHidden(true);

  for(int x=0;x<modules.size();x++) {
    QPushButton *b = new QPushButton;
    QString s;
    s.append(table_names.at(x));
    s.append(" (" + tbl->get_labels().at(x) + ")");
    b->setText(s);
    b->setIcon(modules.at(x)->get_icon());
    b->setToolTip("This is one of the modules that can be used in the equation below.\n"
                  "Click this to use the layout from this table.");
    button_map[b] = x;
    ui->main_layout->addWidget(b);
    connect(b,&QPushButton::clicked,this,&module_compare::layout_button_clicked);
  }

  ui->renderer->set_data(tbl);
  set_icon("calc_icon&16.png");
}

void module_compare::layout_button_clicked() {
  QPushButton *b = (QPushButton*)QObject::sender();
  tbl->copy_layout(button_map.value(b));
}

module_compare::~module_compare() {
  delete tbl;
  delete ui;
}

void module_compare::on_layout_btn_clicked() {
  table_config_dialog d;
  d.configure(tbl->x_axis(),tbl->y_axis());
  if(d.exec() == table_config_dialog::Accepted) {
    table_geometry g;
    g.x = d.get_xaxis();
    g.y = d.get_yaxis();
    if(tbl->x_axis() == g.x && tbl->y_axis() == g.y) return; // bail if no real change
    tbl->set_layout(g);
  }
}

void module_compare::on_linear_btn_toggled(bool checked) {
  if(checked) tbl->set_interp_type(rfmathtable::INTERP_LINEAR);
}

void module_compare::on_neighbour_btn_toggled(bool checked) {
  if(checked) tbl->set_interp_type(rfmathtable::INTERP_NEIGHBOUR);
}

void module_compare::on_range_btn_toggled(bool checked) {
  tbl->set_null_filter(checked);
}

void module_compare::on_calc_entry_editingFinished() {
  set_equation(ui->calc_entry->text());
}

QString module_compare::get_equation() const {
  return ui->calc_entry->text();
}

bool module_compare::set_equation(const QString &eq) {
  if(tbl->set_equation(eq) == false) {
    ui->eq_err->setHidden(false);
    ui->eq_err->setText(tbl->errors.join('\n'));
    return false;
  } else {
    ui->eq_err->setHidden(true);
    return true;
  }
}

module *module_compare::clone() const {
  module_compare *out = new module_compare(modules);
  out->ui->linear_btn->setChecked(ui->linear_btn->isChecked());
  out->ui->neighbour_btn->setChecked(ui->neighbour_btn->isChecked());
  out->ui->range_btn->setChecked(ui->range_btn->isChecked());
  out->tbl->copy_layout(tbl);
  out->copy_children((module*)this);
  out->ui->calc_entry->setText(get_equation());
  out->set_equation(get_equation());
  out->ui->renderer->import_data(ui->renderer->export_data());
  return out;
}
