#ifndef FILTER_CONFIG_H
#define FILTER_CONFIG_H

#include <QWidget>
#include "../datastructures/rfdatalog.h"
#include "../datastructures/afilter.h"

namespace Ui {
class filter_config_widget;
}

class filter_config_widget : public QWidget
{
  Q_OBJECT

public:
  filter_config_widget(QStringList columns, QWidget *parent = nullptr);
  filter_config_widget(afilter f, QStringList columns, QWidget *parent = nullptr);
  ~filter_config_widget();
  afilter filter;

  void update_filter();

public slots:
  void on_delete_btn_clicked();
  void change_column_list(const QStringList &l);

signals:
  void request_removal(filter_config_widget *c);

private slots:
  void term1_changed(QString s);
  void term2_changed(QString s);
  void on_term2_static_btn_toggled(bool checked);
  void on_term2_static_valueChanged(double arg1);
  void on_comparator_currentIndexChanged(int index);

private:
  Ui::filter_config_widget *ui;
  QStringList columns;

};

#endif // FILTER_CONFIG_H
