#include "filter_list_widget.h"
#include "ui_filter_list_widget.h"

#include <QDebug>
#include <QPushButton>

filter_list_widget::filter_list_widget(QStringList column_list, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::filter_list_widget) {
  ui->setupUi(this);
  columns = column_list;
}

void filter_list_widget::import_filters(QVector<afilter> filters) {
  clear();
  for(int x=0;x<filters.size();x++) {
    filter_config_widget *c = new filter_config_widget(filters.at(x),columns);
    add_filter(c);
  }
}

QVector<afilter> filter_list_widget::export_filters() const {
  QVector<afilter>out;
  for(int x=0;x<list.size();x++) {
    out.append(list.at(x)->filter);
  }
  return out;
}

filter_list_widget::~filter_list_widget() {
  while(list.isEmpty() == false) delete list.takeFirst();
  delete ui;
}

void filter_list_widget::clear() {
  while(list.isEmpty() == false) delete list.takeFirst();
}

void filter_list_widget::on_add_filter_btn_clicked() {
  filter_config_widget *c = new filter_config_widget(columns);
  add_filter(c);
}

void filter_list_widget::add_filter(filter_config_widget *c) {
  list.append(c);
  connect(c,&filter_config_widget::request_removal,this,&filter_list_widget::remove_filter);
  ui->filter_container->addWidget(c);
}

bool filter_list_widget::refactor(rfdatalog *log) {
  bool success = true;
  for(int x=0;x<list.count();x++) {
    if(list[x]->filter.refactor(log) == false) success = false;
  }
  return success;
}

void filter_list_widget::remove_filter(filter_config_widget *c) {
  list.removeAll(c);
  delete c;
}

filter_list_dialog::filter_list_dialog(QStringList columns, QVector<afilter> filters) {
  setWindowTitle("Filter Configuration");
  QVBoxLayout *l = new QVBoxLayout();
  setLayout(l);
  w = new filter_list_widget(columns,this);
  l->addWidget(w);
  QHBoxLayout *h = new QHBoxLayout();
  l->addLayout(h);
  QPushButton *okbtn = new QPushButton("OK");
  connect(okbtn,&QPushButton::clicked,this,&filter_list_dialog::complete);
  h->addWidget(okbtn);
  QPushButton *cancelbtn = new QPushButton("Cancel");
  connect(cancelbtn,&QPushButton::clicked,this,&filter_list_dialog::reject);
  h->addWidget(cancelbtn);
  w->import_filters(filters);
}

void filter_list_dialog::complete() {
  result = w->export_filters();
  accept();
}
