#include "dynamic_col_dialog.h"
#include "ui_dynamic_col_dialog.h"
#include "../widgets/data_selector_widget.h"
#include "../widgets/rftablewidget.h"
#include "../datastructures/rfdatalog.h"
#include "../modules/module_table.h"
#include "../widgets/lookup_config_widget.h"
#include "table_config_dialog.h"
#include <QDialog>
#include <QInputDialog>

dynamic_col_dialog::dynamic_col_dialog(QVector<rfdatalog *> logs, dynamic_column_list *dyn, QWidget *parent) :
  QDialog(parent),
  ui(new Ui::dynamic_col_dialog) {
  ui->setupUi(this);

  for(int x=0;x<logs.size();x++) {
    available_columns.append(logs.at(x)->column_string_list(true));
  }
  available_columns.removeDuplicates();
  available_columns.sort();

  this->logs = logs;
  this->dyn = dyn;
  render_list();
}

dynamic_col_dialog::~dynamic_col_dialog() {
  delete ui;
}

void dynamic_col_dialog::render_list() {
  // render col list and select nothing then render
  ui->col_list->clear();
  for(int x=0;x<dyn->size();x++) {
    QListWidgetItem *i = new QListWidgetItem;
    i->setText(dyn->at(x).name);
    ui->col_list->addItem(i);
  }
  render_column();
}

void dynamic_col_dialog::render_column() {
  dynamic_column *c = current_column();
  if(c == nullptr) {
    ui->scrollArea->setEnabled(false);
    return;
  } else {
    ui->scrollArea->setEnabled(true);
  }
  refresh_var_names();
  ui->equation_box->setText(c->equation);
  refresh_equation();
}

dynamic_column *dynamic_col_dialog::current_column() {
  QVector <QListWidgetItem*>selection = ui->col_list->selectedItems();
  if(selection.size() != 1) return nullptr;
  QListWidgetItem *i = selection.at(0);
  int r = ui->col_list->row(i);
  return dyn->ptr(r);
}

void dynamic_col_dialog::on_add_column_btn_clicked() {
  dynamic_column *c = current_column();
  if(c == nullptr) return;
  data_selector_widget d("Select Log Column",available_columns);
  if(d.exec() == data_selector_widget::Accepted) {
    c->add_col_variable(d.selected_element);
    render_column();
  }
}

void dynamic_col_dialog::refresh_var_names() {
  dynamic_column *c = current_column();
  ui->var_list->clear();
  if(c == nullptr) return;
  for(int x=0;x<c->variable_count();x++) {
    ui->var_list->addItem(dynamic_column::var_name(x) + " = " + c->variable_at(x).display_name());
  }
}

void dynamic_col_dialog::on_add_lookup_btn_clicked() {
  dynamic_column *c = current_column();
  if(c == nullptr) return;
  table_dialog t(logs,nullptr,rflookupconfig());
  if(t.exec() == table_dialog::Accepted) {
    c->add_lookup_variable(t.table,t.lookup_config);
    render_column();
  }
}

void dynamic_col_dialog::on_edit_btn_clicked() {
  if(current_column() == nullptr) return;
  QVector<QListWidgetItem*>selection = ui->var_list->selectedItems();
  if(selection.size() == 1) {
    int v_index = ui->var_list->row(selection.at(0));
    dynamic_column *c = current_column();
    dynamic_col_variable v = dyn->at(ui->col_list->row(ui->col_list->selectedItems().at(0))).variable_at(v_index);
    switch (v.col_type) {
    case dynamic_col_variable::COL_DIRECT:
    {
      data_selector_widget d("Select Log Column",available_columns);
      if(d.exec() == data_selector_widget::Accepted) {
        c->edit_col_variable(v_index,d.selected_element);
        render_column();
      }
    }
      break;
    case dynamic_col_variable::COL_LOOKUP:
    {
      table_dialog t(logs,&v.lookup,v.lookup_config);
      if(t.exec() == table_dialog::Accepted) {
        c->edit_lookup_variable(v_index,t.table,t.lookup_config);
        render_column();
      }
    }
      break;
    }
  }
}

void dynamic_col_dialog::on_delete_btn_2_clicked() {
  if(current_column() == nullptr) return;
  QVector <QListWidgetItem*> selection = ui->var_list->selectedItems();
  if(selection.size() != 1) return;
  current_column()->delete_variable(ui->var_list->row(selection.at(0)));
  render_column();
}

void dynamic_col_dialog::on_var_list_itemSelectionChanged() {
  int s = ui->var_list->selectedItems().size();
  if(s == 0) {
    ui->delete_btn_2->setEnabled(false);
    ui->edit_btn->setEnabled(false);
  } else {
    ui->delete_btn_2->setEnabled(true);
    ui->edit_btn->setEnabled(true);
  }
}

void dynamic_col_dialog::on_col_list_itemSelectionChanged() {
  render_column();
}

table_dialog::table_dialog(QVector <rfdatalog*>logs, rftable *tbl, rflookupconfig conf) {
  this->logs = logs;
  resize(800,600);

  lookup_config = conf;

  this->logs = logs;

  QVBoxLayout *box = new QVBoxLayout;
  setLayout(box);

  table_editor = new module_table(logs);
  box->addWidget(table_editor);

  if(tbl != nullptr) table_editor->set_table(*tbl);

  lookup_widget = new lookup_config_widget();
  box->addWidget(lookup_widget);
  lookup_widget->set(lookup_config);

  ok_btn = new QPushButton("OK");

  QPushButton *cancel_btn = new QPushButton("Cancel");
  QHBoxLayout *l2 = new QHBoxLayout;
  l2->addWidget(ok_btn);
  l2->addWidget(cancel_btn);
  box->addLayout(l2);

  connect(table_editor->get_data(),&rftablemodel::data_changed,this,&table_dialog::table_modified);
  connect(table_editor->get_data(),&rftablemodel::geometry_changed,this,&table_dialog::table_modified);
  connect(ok_btn,&QPushButton::clicked,this,&table_dialog::finalize);
  connect(cancel_btn,&QPushButton::clicked,this,&table_dialog::reject);

  table_modified();
}

void table_dialog::finalize() {
  lookup_config = lookup_widget->get();
  table_modified();
  accept();
}

void table_dialog::table_modified() {
  rftable t(table_editor->get_table());
  ok_btn->setEnabled(t.x_axis().is_valid() && t.y_axis().is_valid());
  table.copy_data(t);
}

void dynamic_col_dialog::on_add_btn_clicked() {
  QInputDialog d;
  d.setWindowTitle("Enter name");
  if(d.exec() == QInputDialog::Accepted) {
    dynamic_column c;
    c.name = d.textValue();
    dyn->append(c);
    render_list();
  }
}

void dynamic_col_dialog::on_delete_btn_clicked() {
  dynamic_column *c = current_column();
  if(c == nullptr) return;
  QVector <QListWidgetItem*>selection = ui->col_list->selectedItems();
  if(selection.size() != 1) return;
  int r = ui->col_list->row(selection.at(0));
  dyn->removeAt(r);
  render_list();
}

void dynamic_col_dialog::on_equation_box_textChanged(const QString &arg1) {
  QVector <QListWidgetItem*>selection = ui->col_list->selectedItems();
  if(selection.size() != 1) return;
  dynamic_column *c = dyn->ptr(ui->col_list->row(selection[0]));
  c->set_equation(arg1);
  refresh_equation();
}

void dynamic_col_dialog::refresh_equation() {
  dynamic_column *c = current_column();
  if(c == nullptr) return;
  if(c->equation_errors.isEmpty() == false) {
    ui->eq_err->setText(c->equation_errors);
  } else {
    ui->eq_err->setText("OK");
  }
}

void dynamic_col_dialog::on_save_btn_clicked() {
  accept();
}

void dynamic_col_dialog::on_cancel_btn_clicked() {
  reject();
}
