#ifndef IMPORT_XDF_DIALOG_H
#define IMPORT_XDF_DIALOG_H

#include <QDialog>
#include <QXmlStreamReader>
#include "../datastructures/table_geometry.h"
class QListWidgetItem;

namespace Ui {
class import_xdf_dialog;
}

class import_xdf_dialog : public QDialog {
  Q_OBJECT

public:
  explicit import_xdf_dialog(QWidget *parent = nullptr);
  ~import_xdf_dialog();
  table_geometry selected_table;
private slots:
  void on_xdf_btn_clicked();

  void on_parameter_list_itemSelectionChanged();

  void on_ok_btn_clicked();

  void on_cancel_btn_clicked();

  void on_parameter_list_itemDoubleClicked(QListWidgetItem *item);

  void on_filter_box_textEdited(const QString &arg1);

private:
  void parse_xdf();
  Ui::import_xdf_dialog *ui;
  QXmlStreamReader xdf;
  double xdf_version = 0.00;
  QVector <table_geometry>tables;

  bool matches_search(const QStringList &search, const QString &text);
};

#endif // IMPORT_XDF_DIALOG_H
