#ifndef AXIS_CONFIGURATOR_H
#define AXIS_CONFIGURATOR_H

#include <QWidget>
#include "../datastructures/rfanalysis.h"
#include "../datastructures/rfdatalog.h"

namespace Ui {
class axis_configurator_widget;
}

class axis_configurator_widget : public QWidget {
  Q_OBJECT

public:
  explicit axis_configurator_widget(QWidget *parent = nullptr);
  ~axis_configurator_widget();

  bool is_valid() const;

  table_axis generate_axis() const;
  static int calc_precision(const QStringList &l);
  void load_axis(const QStringList &values);
  void load_axis(const table_axis &axis);
  QStringList parse_input() const;
  QVector<double> get_values(const QStringList &l) const;
  static QStringList estimate_values(double min, double max, int count);

public slots:
  void refresh_ui();

  void autofill(double min, double max, int count);

signals:
  void changed();

private slots:
  void on_layout_arbitrary_edit_textChanged();

  void on_precision_box_valueChanged(int arg1);

private:
  Ui::axis_configurator_widget *ui;
};

#endif // AXIS_CONFIGURATOR_H
