#ifndef CHART_CONFIG_ITEM_H
#define CHART_CONFIG_ITEM_H

#include <QWidget>
#include "../datastructures/rfdatalog.h"

namespace Ui {
class chart_config_item;
}

class QCPAxis;
class QCPGraph;
class rftablemodel;

class chart_config_item : public QWidget {
  Q_OBJECT

public:
  ~chart_config_item();
  chart_config_item(QCPGraph *graph, rfdatalog *log, QWidget *parent = nullptr);

  QColor selected_color() const;
  static QVector<QColor> color_list();
  int selected_color_index() const;
  void set_color(int i);
  void next_color();

  QCPAxis *axis = nullptr;
  QCPGraph *graph = nullptr;

public slots:
  void column_selected(QString s);
signals:
  void item_delete_request(chart_config_item *w);

private slots:
  void on_delete_btn_clicked();
  void on_range_low_box_valueChanged(double arg1);
  void on_range_high_box_valueChanged(double arg1);
  void on_calc_btn_clicked();
  void on_color_btn_clicked();

private:
  Ui::chart_config_item *ui;
  rfdatalog *log = nullptr;
  int color_index = 0;
};

#endif // CHART_CONFIG_ITEM_H
