#ifndef FILTER_LIST_H
#define FILTER_LIST_H

#include <QWidget>
#include <QDialog>
#include "filter_config_widget.h"

namespace Ui {
class filter_list_widget;
}

class filter_list_widget : public QWidget {
  Q_OBJECT

public:
  explicit filter_list_widget(QStringList column_list, QWidget *parent = nullptr);
  void import_filters(QVector<afilter>filters);
  QVector<afilter>export_filters() const;
  ~filter_list_widget();
  void clear();

private slots:
  void on_add_filter_btn_clicked();
  void remove_filter(filter_config_widget *c);

private:
  Ui::filter_list_widget *ui;
  QVector <filter_config_widget*>list;
  QStringList columns;
  void add_filter(filter_config_widget *c);
  bool refactor(rfdatalog *log);
};

class filter_list_dialog : public QDialog {
  Q_OBJECT
public:
  explicit filter_list_dialog(QStringList columns, QVector<afilter>filters);
  QVector<afilter>result;
public slots:
  void complete();
private:
  filter_list_widget *w = nullptr;

};

#endif // FILTER_LIST_H
