#ifndef DATALOG_LOAD_DIALOG_H
#define DATALOG_LOAD_DIALOG_H

#include <QDialog>

namespace Ui {
class datalog_load_dialog;
}

class rfdatalog;

class datalog_load_dialog : public QDialog {
  Q_OBJECT

public:
  explicit datalog_load_dialog(QString filename, QWidget *parent = nullptr);
  ~datalog_load_dialog();

  void error(const QString &err_msg);
  void config_datalog(rfdatalog *log, bool trial);
  bool decode(const QString &in);
  bool validate(const QString &in) const;
  QString encode() const;

private slots:
  void on_cancel_btn_clicked();
  void refresh_log();
  void on_ok_btn_clicked();
  void on_csv_box_toggled(bool checked);
  void on_tsv_box_toggled(bool checked);
  void on_header_line_box_valueChanged(int arg1);
  void on_data_line_box_valueChanged(int arg1);
  void on_boolean_translate_btn_toggled(bool checked);
  void on_shitty_datalog_toggled(bool checked);

private:
  QString filename;
  Ui::datalog_load_dialog *ui;
  bool loading = false;
  QStringList col_list;
  QStringList last_col_list;
  rfdatalog *log = nullptr;
};

#endif // DATALOG_LOAD_DIALOG_H
