#ifndef ANALYZER_CONFIG_DIALOG_H
#define ANALYZER_CONFIG_DIALOG_H

#include <QDialog>
#include "../datastructures/rfdatalog.h"
#include "../datastructures/rfanalysis.h"

namespace Ui {
class table_config_dialog;
}

class column_button;
class axis_configurator_widget;

class table_config_dialog: public QDialog {
  Q_OBJECT

public:
  table_config_dialog(QVector<rfdatalog *> logs = QVector <rfdatalog*>());
  void autoconfig_column(column_button *c, axis_configurator_widget *w);

  table_axis get_xaxis() const;
  table_axis get_yaxis() const;
  void configure(table_axis xaxis, table_axis yaxis);
  bool is_2d() const;
  bool is_3d() const;

public slots:
  void update_ui();

private slots:
  void on_cancel_btn_clicked();
  void on_ok_btn_clicked();
  void on_autosize_btn_clicked();
  void on_swap_btn_clicked();
  void on_xdf_btn_clicked();
  void on_database_btn_clicked();

  void on_romraider_btn_clicked();

private:
  Ui::table_config_dialog *ui;
  QVector <rfdatalog*>logs;
};

#endif // ANALYZER_CONFIG_DIALOG_H
