#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "modules/module_analyzer.h"
#include "modules/module_grapher.h"
#include "modules/module.h"
#include "modules/module_datalog.h"
#include "database.h"
#include "dialogs/advanced.h"
#include "datastructures/dynamic_column.h"

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE

class MainWindow : public QMainWindow {
  Q_OBJECT

public:
  MainWindow(QWidget *parent = nullptr);
  ~MainWindow();

  void import_csv(QString filename);
  void errormsg(const QString &s);
  QVector <module*>selected_modules();
  void add_module(module *m);
  QVector<module *> modules() const;

  module *module_for_list_item(QListWidgetItem *i) const;
  void clean_dependancies();
private slots:

  void on_delete_btn_clicked();
  void on_splitter_splitterMoved(int pos, int index);
  void on_advanced_btn_clicked();
  void on_datalog_btn_clicked();
  void on_analysis_btn_clicked();
  void on_table_btn_clicked();
  void on_graph_btn_clicked();
  void on_list_itemSelectionChanged();
  void on_compare_btn_clicked();
  void on_graph_2d_btn_clicked();
  void on_about_btn_clicked();
  void on_clone_btn_clicked();
  void on_dynamic_col_btn_clicked();

private:
  Ui::MainWindow *ui;
  advanced *adv = nullptr;
  void update_selection_context();
  bool closing = false;
  QHash <unsigned int,module*>module_list;
  void remove_module(module *m);
  QVector<module *> child_tree(module *m);
  QVector<module *> module_parents(module *m);
  QVector<rfdatalog *> all_datalogs() const;
  QVector<module *> modules_of_type(module::_module_type mod_type) const;
  dynamic_column_list dynamic_columns() const;
};
#endif // MAINWINDOW_H
