#include "interpolation_dialog.h"
#include "ui_interpolation_dialog.h"

interpolation_dialog::interpolation_dialog(QWidget *parent) :
  QDialog(parent),
  ui(new Ui::interpolation_dialog) {

  ui->setupUi(this);

  selection = rftable::INTERPOLATE;
  config.tail = table_interpolation::CONTINUE;
  config.method = table_interpolation::LINEAR;

}

void interpolation_dialog::disable_interpolation() {
  ui->label->setText(ui->label->text() + "\n" + "Due to incomplete table data, interpolation is not reliable.\n"
                                                "To use interpolation, please cancel and fill all missing data.");
  ui->clear_btn->setChecked(true);
  ui->interpolate_btn->setEnabled(false);
}

void interpolation_dialog::on_interpolate_btn_toggled(bool checked) {
  ui->algorithm_group->setEnabled(checked);
  ui->tail_group->setEnabled(checked);
  if(checked) selection = rftable::INTERPOLATE;
}

void interpolation_dialog::on_clear_btn_toggled(bool checked) {
  if(checked) selection = rftable::CLEAR_ALL;
}

void interpolation_dialog::on_overwrite_btn_toggled(bool checked) {
  if(checked) selection = rftable::OVERWRITE;
}

void interpolation_dialog::on_algo_bilinear_btn_toggled(bool checked) {
  if(checked) config.method = table_interpolation::LINEAR;
}

void interpolation_dialog::on_algo_bicubic_btn_toggled(bool checked) {
  if(checked) config.method = table_interpolation::SPLINE;
}

void interpolation_dialog::on_zero_btn_toggled(bool checked) {
  config.tail = table_interpolation::ZERO;
}

void interpolation_dialog::on_cancel_btn_clicked() {
  reject();
}

void interpolation_dialog::on_accept_btn_clicked() {
  accept();
}

void interpolation_dialog::on_clear_mismatch_btn_toggled(bool checked) {
    if(checked) selection = rftable::CLEAR_NONMATCHING;
}

void interpolation_dialog::on_neighbour_btn_toggled(bool checked) {
    if(checked) config.method = table_interpolation::NEIGHBOUR;
}

void interpolation_dialog::on_continue_2_toggled(bool checked) {
    config.tail = table_interpolation::CONTINUE;
}
