#ifndef CHART_ELEMENT_DIALOG_H
#define CHART_ELEMENT_DIALOG_H

#include <QDialog>
#include "../datastructures/rftablemodel.h"
#include "../widgets/chart_config_item.h"

class QCustomPlot;

namespace Ui {
class chart_element_dialog;
}

class chart_element_dialog : public QDialog {
  Q_OBJECT

public:
  explicit chart_element_dialog(QCustomPlot *plot, rfdatalog *log, QWidget *parent = nullptr);
  ~chart_element_dialog();

  QColor selected_color() const;
  QString selected_element() const;
  double high_range() const;
  double low_range() const;

private slots:

  void on_ok_btn_clicked();
  void delete_requested(chart_config_item *i);
  void on_add_btn_clicked();

private:
  Ui::chart_element_dialog *ui;
  rfdatalog *log;
  QCustomPlot *plot;
  QVector <chart_config_item*>items;

};

#endif // CHART_ELEMENT_DIALOG_H
