#include "chart_config_item.h"
#include "ui_chart_config_item.h"
#include "qcustomplot.h"
#include "../datastructures/rfdatalog.h"

chart_config_item::chart_config_item(QCPGraph *graph, rfdatalog *log, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::chart_config_item) {
  ui->setupUi(this);

  this->graph = graph;
  this->log = log;

  axis = graph->valueAxis();


  QSignalBlocker q(this);

  color_index = 0;
  for(int x=0;x<color_list().size();x++) {
    if(axis->labelColor() == color_list().at(x)) {
      color_index = x;
      break;
    }
  }
  set_color(color_index);

  ui->range_low_box->setValue(axis->range().lower);
  ui->range_high_box->setValue(axis->range().upper);

  q.unblock();

  ui->col_button->set_columns(log);
  ui->col_button->set_column(axis->label());

  connect(ui->col_button,&column_button::column_selected,this,&chart_config_item::column_selected);
}

chart_config_item::~chart_config_item() {
  delete ui;
}

void chart_config_item::column_selected(QString s) {
  axis->setLabel(s);
  on_calc_btn_clicked();
}

void chart_config_item::on_delete_btn_clicked() {
  emit item_delete_request(this);
}

void chart_config_item::on_range_low_box_valueChanged(double arg1) {
  Q_UNUSED(arg1)
  axis->setRange(ui->range_low_box->value(),ui->range_high_box->value());
}

void chart_config_item::on_range_high_box_valueChanged(double arg1) {
  Q_UNUSED(arg1)
  axis->setRange(ui->range_low_box->value(),ui->range_high_box->value());
}

void chart_config_item::on_calc_btn_clicked() {
  int i = log->col_index(ui->col_button->col_name);
  if(i == -1) return;
  QVector<double>values = log->col_vector(i);
  double min = __DBL_MAX__;
  double max = __DBL_MIN__;
  for(int x=0;x<values.size();x++) {
    double v = values.at(x);
    if(v < min) min = v;
    if(v > max) max = v;
  }
  static QVector<double>valid_ranges = {0.01, 0.05, 0.10, 0.25, 0.5, 1, 1.5, 5, 10, 15, 20, 25, 50, 100, 150, 200, 250, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000};
  double z1 = .01;
  for(int x=0;x<valid_ranges.size();x++) {
    if(max < valid_ranges.at(x)) {
      z1 = valid_ranges.at(x);
      break;;
    }
  }
  if(min < 0) {
    for(int x=0;x<valid_ranges.size();x++) {
      if(0 - min < valid_ranges.at(x) && valid_ranges.at(x) > z1) {
        z1 = valid_ranges.at(x);
        break;;
      }
    }
  }
  double z0 = 0;
  if(min < 0) z0 = 0 - z1;

  ui->range_low_box->setValue(z0);
  ui->range_high_box->setValue(z1);
}

QColor chart_config_item::selected_color() const {
  return color_list().at(color_index);
}

int chart_config_item::selected_color_index() const {
  return color_index;
}

void chart_config_item::set_color(int i) {
  color_index = i;
  ui->color_btn->set_color(selected_color());
  axis->setLabelColor(selected_color());
  axis->setTickLabelColor(selected_color());
  axis->setTickPen(QPen(selected_color()));
  graph->setPen(QPen(QBrush(selected_color()),1));
}

QVector<QColor> chart_config_item::color_list() {
  QVector<QColor>out;
  out.append(Qt::darkRed);
  out.append(Qt::darkGreen);
  out.append(Qt::darkCyan);
  out.append(Qt::darkMagenta);
  out.append(Qt::darkYellow);
  out.append(Qt::darkGray);
  out.append(Qt::black);
  return out;
}

void chart_config_item::on_color_btn_clicked() {
  next_color();
}

void chart_config_item::next_color() {
  color_index++;
  if(color_index > color_list().size() - 1) color_index = 0;
  set_color(color_index);
}
