#include "rfsqltable.h"
#include "rftablemodel.h"
#include "database.h"
#include <QSqlRecord>
#include <QVariant>

rfsqltable::rfsqltable(const QString &table_name)  {
  QSqlQuery q(*database::db_instance());
  q.prepare("SELECT * FROM " + table_name);
  if(q.exec() == false) {
    _valid = false;
    return;
  }
  load_table(q);
}

rfsqltable::rfsqltable(QSqlQuery &q) {
  load_table(q);
}

void rfsqltable::load_table(QSqlQuery &q) {
  data.clear();
  header.clear();
  _n_rows = 0;
  int n = q.record().count();
  _n_cols = n;
  for(int x=0;x<n;x++) {
    header.append(q.record().fieldName(x));
  }
  if(q.first() == false) return;
  do {
    for(int x=0;x<n;x++) data.append(q.value(x).toString());
    _n_rows++;
  } while(q.next() == true);
  _valid = true;
}

int rfsqltable::n_columns() const {
  return _n_cols;
}

int rfsqltable::n_rows() const {
  return _n_rows;
}

QString rfsqltable::col_name(const int &col) const {
  if(col < 0 || col > _n_cols - 1) return QString();
  return header.at(col);
}

QString rfsqltable::row_name(const int &row) const {
  return QString::number(row);
}

QString rfsqltable::string_at(const int &row, const int &col) const {
  int i = data_index(row,col);
  if(i < 0 || i > data.size() - 1) return QString();
  return data.at(i);
}

int rfsqltable::data_index(const int &row, const int &col) const {
  return ( row * _n_cols ) + col;
}
