#ifndef REGRESSION_H
#define REGRESSION_H

#include "table_geometry.h"
#include <QVector>

/* some math is based on a project on
 * https://www.geeksforgeeks.org/regression-analysis-and-the-best-fitting-line-using-c/ */

class regression {
public:
  regression();
  void add_point(const double &x, const double &y);
  bool is_valid() const;
  void clear();
  int size() const;
  double at(double x) const;
  double error_square() const;
  double error_at(double num) const;
  bool data_reliable(double max_err_sq) const;
  double min;
  double max;
  int calculate();

private:
  QVector<double> x_values;
  QVector<double> y_values;
  double coeff;
  double constTerm;
  double sum_xy;
  double sum_x;
  double sum_y;
  double sum_x_square;
  double sum_y_square;
  void calc_coefficient();
  void calc_constant_term();
};

class regression_set {
public:
  regression_set(QVector <double>points);
  regression_set();
  void configure(QVector <double>points);
  void add_data(const double &x, const double &y);
  double at(const double &x) const;
  bool data_reliable(const double &x) const;
  void calculate();
  int count(const double &x) const;
  double min(const double &x) const;
  double max(const double &x) const;
  void print();
  double err_square(const double &x) const;
 private:
  QVector <double>points;
  QVector <double>point_medians;
  QVector <regression>values;
  int locate_index(const double &value) const;
  int locate_overlap(const double &value, const int &origin_index) const;
  double avg_err = 0;
  double max_err() const;
};

class regression_table {
public:
  enum _analysis_mode {
    XLINEAR,
    YLINEAR,
    BILINEAR
  };

  regression_table(table_axis x_axis, table_axis y_axis, _analysis_mode mode);
  regression_table(table_axis y_axis);
  void add_data(const double &x, const double &y, const double &z);
  void calculate();
  bool is_null(const int &xi, const int &yi);
  double at(const int &xi, const int &yi) const;
  int count_at(const int &xi, const int &yi) const;
  double min_at(const int &xi, const int &yi) const;
  double max_at(const int &xi, const int &yi) const;
  double max_at(const int &yi) const;
  bool dbg();
  void add_data(const double &y, const double &z);
  double at(const int &yi) const;
  int count_at(const int &yi) const;
  double min_at(const int &yi) const;
  bool is_null(const int &yi);
private:
  table_axis x_axis;
  table_axis y_axis;
  bool calculated = false;
  QVector <regression_set>x_regressions;
  QVector <regression_set>y_regressions;
  _analysis_mode mode;
};

#endif // REGRESSION_H
