#ifndef TABLE_ANALYZER_H
#define TABLE_ANALYZER_H

#include <QWidget>
#include "../datastructures/rfdatalog.h"
#include "../datastructures/rfanalysis.h"
#include "module.h"
#include "module_datalog.h"

namespace Ui {
class module_analyzer;
}

class module_analyzer : public module {
  Q_OBJECT

public:
  module_analyzer(QVector<rfdatalog *> logs);
  ~module_analyzer();

  module * clone() const override;

  bool is_valid() const;
  QString generate_name() const;

  void set_view(const QString &view);
  void get_view();
  rftablemodel * get_data() override;
  _module_type module_type() override { return MODULE_TABLE;};

  int determine_precision(const QString &col_name);
  void update_ui();
  int determine_precision(const QString &col_name, rfdatalog *log);

  void reset_ui_context();

  dbdata export_data() const;
  bool import_data(const dbdata &data);


public slots:
  void analyze();
  void configure_layout();
  void new_data_selected();
  void source_log_data_changed();

private slots:
  void on_config_btn_clicked();
  void on_avg_btn_toggled(bool checked);
  void on_max_btn_toggled(bool checked);
  void on_min_btn_toggled(bool checked);
  void on_count_btn_toggled(bool checked);
  void refresh_name();
  void on_filter_btn_clicked();
  void on_mincount_box_valueChanged(int arg1);
  void on_lagfilter_box_valueChanged(double arg1);
  void on_cut_btn_toggled(bool checked);
  void on_mode_box_currentIndexChanged(int index);
  void on_calc_expression_editingFinished();
  void on_calc_btn_toggled(bool checked);
  void on_database_btn_clicked();

protected:
  Ui::module_analyzer *ui;
  QVector <rfdatalog*> logs;
  rfanalysis *anl = nullptr;

private:
  QString name_override;
  int _precision_memory = -1;
};

#endif // TABLE_ANALYZER_H
