#ifndef DATABASE_DIALOG_H
#define DATABASE_DIALOG_H

#include <QDialog>
#include "database.h"
#include <QListWidgetItem>

namespace Ui {
class database_dialog;
}

class database_dialog : public QDialog
{
  Q_OBJECT

public:
  ~database_dialog();

  database_dialog(const QString &table_name, const dbdata &original_item, QWidget *parent = nullptr);
  dbdata selected_item;

public slots:
  void reload_contents();
private slots:
  void on_text_entry_textEdited(const QString &arg1);
  void on_load_btn_clicked();
  void on_save_btn_clicked();
  void on_replace_btn_clicked();
  void on_db_list_itemSelectionChanged();
  void on_delete_btn_clicked();
  void on_cancel_btn_clicked();
  void on_db_list_itemDoubleClicked(QListWidgetItem *item);
  void on_copy_btn_clicked();
  void on_paste_btn_clicked();

private:
  Ui::database_dialog *ui;
  bool matches_search(const QStringList &search, const QString &text);
  QVector <dbdata>data;
  dbdata original_item;
  QString table_name;
};

#endif // DATABASE_DIALOG_H
