#ifndef TABLE_VIEWER_H
#define TABLE_VIEWER_H

#include <QWidget>

#include "../datastructures/rftablemodel.h"
#include "module.h"

namespace Ui {
class module_datalog;
}

class module_datalog : public module {
  Q_OBJECT

public:
  explicit module_datalog(rfdatalog *data_in, const QString &name);
  ~module_datalog();
  rftablemodel * get_data() override;
  rfdatalog *get_datalog() {return data;};
  _module_type module_type() override { return MODULE_DATALOG;};

  module * clone() const override;

public slots:

private:
  rfdatalog *data = nullptr;
  Ui::module_datalog *ui;
};

#endif // TABLE_VIEWER_H
