#ifndef GRAPHER_H
#define GRAPHER_H

#include <QWidget>
#include "../datastructures/rftablemodel.h"
#include "../modules/module.h"
#include <QtDataVisualization>
#include <QTableView>
#include <QItemModelSurfaceDataProxy>
#include <QResizeEvent>

namespace Ui {
class module_grapher;
}

class module_grapher : public module {
  Q_OBJECT

public:
  explicit module_grapher(module *parent = nullptr);
  ~module_grapher();

  QString generate_name() const;
  _module_type module_type() override { return MODULE_GRAPH;};
  rftablemodel *get_data() override;
  void resizeEvent(QResizeEvent *event) override;

  float get_zoom();

  module * clone() const override;

public slots:
  void set_gradient(QColor a, QColor b, QColor c, QColor d);
  void set_zoom(float zoom);
  void zoom_changed(float zoom);

  void refresh();

private:
  Ui::module_grapher *ui;
  Q3DSurface *graph;
  bool attach_graph(Q3DSurface *graph);
  rftablemodelqtproxy data;
  QItemModelSurfaceDataProxy *proxy;
  QSurface3DSeries *series;
  Q3DCamera *camera() const { return graph->scene()->activeCamera(); };
  QWidget *container = nullptr;
};

#endif // GRAPHER_H
