#ifndef DATA_SELECTOR_H
#define DATA_SELECTOR_H

#include <QDialog>
#include <QListWidgetItem>
#include <QPushButton>
#include "../datastructures/rfdatalog.h"

namespace Ui {
class data_selector_widget;
}

class data_selector_widget : public QDialog {
  Q_OBJECT

public:
  explicit data_selector_widget(const QString name, const QStringList &values, QWidget *parent = nullptr);
  ~data_selector_widget();

  bool matches_search(const QStringList &search, const QString &text);

  QString selected_element;
  int selected_index = -1;

private slots:
  void on_element_search_textEdited(const QString &arg1);
  void on_cancel_btn_clicked();
  void on_ok_btn_clicked();
  void on_element_list_itemSelectionChanged();
  void on_element_list_itemDoubleClicked(QListWidgetItem *item);

private:
  Ui::data_selector_widget *ui;
};

class column_button : public QPushButton {
  Q_OBJECT
public:
  column_button(QWidget *parent);
  bool is_valid() const;
  void set_column(const QString &col_name);
  void set_columns(rftablemodel *d);
  void set_columns(const QStringList &s);

  void update_text();
  QString col_name;

signals:
  void column_selected(QString col_name);
  void changed();

private slots:
  void popup();

private:
  QStringList cols;

};

#endif // DATA_SELECTOR_H
