#include "filter_config_widget.h"
#include "ui_filter_config_widget.h"
#include "data_selector_widget.h"
#include <QDebug>

filter_config_widget::filter_config_widget(QStringList columns, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::filter_config_widget) {
  ui->setupUi(this);
  for(int x=0;x<afilter::N_OPERATORS;x++) {
    ui->comparator->addItem(afilter::operator_symbol((afilter::operator_e)x));
  }
  if(columns.isEmpty() == false) change_column_list(columns);
  connect(ui->term1_btn,&column_button::column_selected,this,&filter_config_widget::term1_changed);
  connect(ui->term2_btn,&column_button::column_selected,this,&filter_config_widget::term2_changed);
}

filter_config_widget::filter_config_widget(afilter f, QStringList columns, QWidget *parent) :
  QWidget(parent), ui(new Ui::filter_config_widget) {
  ui->setupUi(this);
  for(int x=0;x<afilter::N_OPERATORS;x++) {
    ui->comparator->addItem(afilter::operator_symbol((afilter::operator_e)x));
  }
  filter = f;
  if(columns.isEmpty() == false) change_column_list(columns);
  connect(ui->term1_btn,&column_button::column_selected,this,&filter_config_widget::term1_changed);
  connect(ui->term2_btn,&column_button::column_selected,this,&filter_config_widget::term2_changed);
}

void filter_config_widget::update_filter() {
  ui->term2_static_btn->setChecked(filter.term2_static);
  ui->term2_static->setValue(filter.term2_value);
  on_term2_static_btn_toggled(filter.term2_static); //trigger from non user input

  ui->comparator->setCurrentIndex(filter.operation);

  ui->term1_btn->set_column(filter.term1_colname);
  ui->term2_btn->set_column(filter.term2_colname);
}

filter_config_widget::~filter_config_widget() {
  delete ui;
}

void filter_config_widget::on_delete_btn_clicked() {
  emit request_removal(this);
}

void filter_config_widget::change_column_list(const QStringList &l) {
  columns = l;

  ui->term1_btn->set_columns(l);
  ui->term2_btn->set_columns(l);

  update_filter();
}

void filter_config_widget::term1_changed(QString s) {
  filter.term1_colname = s;
  filter.term1_colindex = -1;
}

void filter_config_widget::term2_changed(QString s) {
  filter.term2_colname = s;
  filter.term2_colindex = -1;
}


void filter_config_widget::on_term2_static_btn_toggled(bool checked) {
  ui->term2_btn->setHidden(checked);
  ui->term2_static->setHidden(! checked);
  filter.term2_static = checked;
}

void filter_config_widget::on_term2_static_valueChanged(double arg1) {
  filter.term2_value = arg1;
}

void filter_config_widget::on_comparator_currentIndexChanged(int index) {
  filter.operation = (afilter::operator_e)index;
}
