#include "lookup_config_widget.h"
#include "ui_lookup_config_widget.h"
#include "../datastructures/rftablemodel.h"

lookup_config_widget::lookup_config_widget(QWidget *parent) : QWidget(parent),
  ui(new Ui::lookup_config_widget) {
  ui->setupUi(this);
}

void lookup_config_widget::set(const rflookupconfig &config) {
  ui->mode_linear->setChecked(config.lookup_type == rflookupconfig::LOOKUP_LINEAR);
  ui->mode_neighbour->setChecked(config.lookup_type == rflookupconfig::LOOKUP_NEIGHBOUR);
  ui->tail_flat->setChecked(config.tail_type == rflookupconfig::TAIL_FLAT);
  ui->tail_null->setChecked(config.tail_type == rflookupconfig::TAIL_NULL);
  ui->tail_continue->setChecked(config.tail_type == rflookupconfig::TAIL_LINEAR);
}

rflookupconfig lookup_config_widget::get() const {
  rflookupconfig out;
  if(ui->mode_linear->isChecked()) out.lookup_type = rflookupconfig::LOOKUP_LINEAR;
  if(ui->mode_neighbour->isChecked()) out.lookup_type = rflookupconfig::LOOKUP_NEIGHBOUR;
  if(ui->tail_flat->isChecked()) out.tail_type = rflookupconfig::TAIL_FLAT;
  if(ui->tail_null->isChecked()) out.tail_type = rflookupconfig::TAIL_NULL;
  if(ui->tail_continue->isChecked()) out.tail_type = rflookupconfig::TAIL_LINEAR;
  return out;
}

lookup_config_widget::~lookup_config_widget() {
  delete ui;
}
