#ifndef BOXFLOWWIDGET_H
#define BOXFLOWWIDGET_H

#include <QWidget>
#include <QLabel>
#include "../modules/module.h"

class module_container_widget : public QWidget {
  Q_OBJECT
public:
  explicit module_container_widget(QWidget *parent = nullptr);

  void add_module(module *m);
  void set_active_modules(QVector <module*>visible_list);

  int set_columns(int n);

  void resizeEvent(QResizeEvent *event) override;

  QVector<module *> modules();
  QVector<module *> visible_modules();
  QVector<module *> hidden_modules();

  void show_logo();
  QLabel logo;
public slots:
  void calculate_layout();
signals:

private:
  int columns = 1;

};

#endif // BOXFLOWWIDGET_H
