#ifndef INTERPOLATION_DIALOG_H
#define INTERPOLATION_DIALOG_H

#include <QDialog>
#include "../datastructures/table_geometry.h"
#include "../datastructures/rftable.h"

namespace Ui {
class interpolation_dialog;
}

class interpolation_dialog : public QDialog {
  Q_OBJECT
public:
  interpolation_dialog(QWidget *parent = nullptr);

  rftable::_layout_handler selection;
  table_interpolation config;

  void disable_interpolation();

private slots:
  void on_interpolate_btn_toggled(bool checked);
  void on_clear_btn_toggled(bool checked);
  void on_overwrite_btn_toggled(bool checked);
  void on_algo_bilinear_btn_toggled(bool checked);
  void on_algo_bicubic_btn_toggled(bool checked);
  void on_zero_btn_toggled(bool checked);
  void on_cancel_btn_clicked();
  void on_accept_btn_clicked();
  void on_clear_mismatch_btn_toggled(bool checked);
  void on_neighbour_btn_toggled(bool checked);

  void on_continue_2_toggled(bool checked);

private:
  Ui::interpolation_dialog *ui;
};

#endif // INTERPOLATION_DIALOG_H
