#ifndef DISPLAYWIDGET_H
#define DISPLAYWIDGET_H

#include <QWidget>
#include "../datastructures/rfdatalog.h"
#include "../datastructures/rftablemodel.h"
#include <QListWidgetItem>
#include <QPushButton>

class module_name_button;

class module : public QWidget {
  Q_OBJECT

public:

  enum _module_type {
    MODULE_DATALOG,
    MODULE_TABLE,
    MODULE_GRAPH,
    MODULE_UNDEFINED
  };

  explicit module(QWidget *parent = nullptr);
  ~module();

  virtual module *clone() const = 0;

  virtual _module_type module_type() { return MODULE_UNDEFINED; };
  QVector<int> children() const { return _children; };

  QListWidgetItem *listwidget = nullptr;
  QString name() const;

  static void error(const QString &err_msg);

  unsigned int id() const { return _id;};

  virtual rftablemodel *get_data() { return nullptr; };

  void add_child(int module_id);
  void add_child(module *m);
  void remove_child(int module_id);
  void copy_children(module *m);

  QIcon get_icon() const;

signals:
  void name_changed(QString name);

public slots:
  void set_name(const QString &s);
  void set_icon(const QString &s);

private:
  unsigned int _id = 0;
  static unsigned int last_id;
  void assign_id();
  QVector<int> _children;
};

#endif // DISPLAYWIDGET_H
