#ifndef TABLE_USER_H
#define TABLE_USER_H

#include <QWidget>
#include "module.h"
#include "../datastructures/rftable.h"

namespace Ui {
class module_table;
}

class module_table : public module {
  Q_OBJECT

public:
  module_table();
  module_table(QVector <rfdatalog*> logs);
  module_table(rftablemodel *data);
  ~module_table();
  rftablemodel * get_data() override;
  _module_type module_type() override { return MODULE_TABLE;};

  void set_table(rftable t);
  rftable get_table() const;
  void store();

  module * clone() const override;

public slots:
  void edit_item(int row, int col);
private slots:
  void on_layout_btn_clicked();
  void on_lineEdit_textChanged(const QString &arg1);
  void on_clr_btn_clicked();
  void on_lineEdit_returnPressed();
  void on_rename_btn_clicked();
  void on_set_btn_clicked();
  void on_undo_btn_clicked();
  void on_redo_btn_clicked();
  void on_db_btn_clicked();

private:
  Ui::module_table *ui;
  rftable *tbl = nullptr;
  QString custom_name;
  QVector <rftable*>undo_cache;
  QVector <rftable*>redo_cache;
  QVector <rfdatalog*>logs;
};

#endif // TABLE_USER_H
