#include "module_container_widget.h"

module_container_widget::module_container_widget(QWidget *parent) : QWidget(parent) {
  //setStyleSheet("background-image:url(:/graphics/logo.png); background-position: center;" );
  //setAutoFillBackground(true);
}

void module_container_widget::show_logo() {

}

void module_container_widget::add_module(module *m) {
  m->setParent(this);
  m->setHidden(true);
}

void module_container_widget::set_active_modules(QVector<module *> visible_list) {
  QVector <module*>mods = modules();
  for(int x=0;x<mods.size();x++) {
    if(visible_list.contains(mods.at(x))) {
      mods.at(x)->setVisible(true);
    } else {
      mods.at(x)->setVisible(false);
    }
  }
  calculate_layout();
}

int module_container_widget::set_columns(int n) {
  if(n < 1) return columns;
  columns = n;
  calculate_layout();
  return n;
}

void module_container_widget::resizeEvent(QResizeEvent *event) {
  calculate_layout();
}

void module_container_widget::calculate_layout() {
  int h_cursor = 0;
  int v_cursor = 0;
  QVector <module*>mods = visible_modules();
  int count = mods.size();
  if(count == 0) return; // avoid later div 0
  int n_columns = columns;
  int n_rows = count / columns;
  if(n_rows == 0) n_rows++;
  int col_width = width() / n_columns;
  int row_height = height() / n_rows;
  for(int row=0;row<n_rows;row++) {
    for(int col=0;col<n_columns;col++) {
      if(mods.isEmpty()) return;
      module *m = mods.takeFirst();
      m->move(h_cursor,v_cursor);
      m->resize(col_width,row_height);
      h_cursor += col_width;
      if(h_cursor >= width()) {
        h_cursor = 0;
        v_cursor += row_height;
      }
    }
  }
}

QVector <module*>module_container_widget::modules() {
  QVector <module*>out;
  QObjectList l = children();
  for(int x=0;x<l.size();x++) {
    module *m = qobject_cast<module*>(l.at(x));
    if(m != nullptr) out.append(m);
  }
  return out;
}

QVector <module*>module_container_widget::visible_modules() {
  QVector <module*>out;
  QObjectList l = children();
  for(int x=0;x<l.size();x++) {
    module *m = qobject_cast<module*>(l.at(x));
    if(m != nullptr && m->isVisible()) out.append(m);
  }
  return out;
}

QVector <module*>module_container_widget::hidden_modules() {
  QVector <module*>out;
  QObjectList l = children();
  for(int x=0;x<l.size();x++) {
    module *m = qobject_cast<module*>(l.at(x));
    if(m != nullptr && m->isVisible() == false) out.append(m);
  }
  return out;
}
