#ifndef FLASH_LAUNCHER_H
#define FLASH_LAUNCHER_H

#include <QWidget>
#include "datastream.h"
#include "bin_file.h"
#include "config.h"
#include "settings.h"

namespace Ui {
class flash_launcher;
}

class flash_launcher : public QWidget {
  Q_OBJECT

public:
  explicit flash_launcher(datastream_control *control_in, datalog *log_in, QWidget *parent = 0);
  ~flash_launcher();
  void on_interface_loaded();

private:
  Ui::flash_launcher *ui;
  datastream_control *control;
  datalog *log;
  eehack_settings config;
  void compare_write_bins();
  void save_bin_file(bin_file *bin);
  QString get_save_filename(QString extension, QString type_name);
  void load_saved_compare_bin();
  void remember_previous_bin_read(QString filename);

private slots:
  void on_btn_readflash_clicked();
  void on_btn_writeflash_clicked();
  void on_bin_write_select_clicked();
  void on_btn_prev_write_select_clicked();
  void on_btn_prev_clr_clicked();
  void on_write_tside_toggled(bool checked);
  void on_write_eside_toggled(bool checked);
  void on_flash_skip_unused_regions_toggled(bool checked);
  void on_patch_master_toggled(bool checked);
  void on_chk_dump_ram_toggled(bool checked);
  void on_patch_about_btn_clicked();
  void on_btn_readflash_2_clicked();

public slots:
  void remember_previous_bin_write();
  void save_read_bin();

signals:
  void info_dialog(QString);
  void error_dialog(QString);
};

#endif // FLASH_LAUNCHER_H
