#ifndef DATALOG_EXTENDED_H
#define DATALOG_EXTENDED_H

#include <QWidget>
#include "datalog.h"
#include "common.h"
#include "config.h"

namespace Ui {
class datalog_extended;
}

class datalog_extended : public QWidget {
  Q_OBJECT

public:
  explicit datalog_extended(QWidget *parent = 0);
  ~datalog_extended();
  void set_definition(datalog_definition *def_in);
private:
  Ui::datalog_extended *ui;
  unsigned int n_elements(datalog_definition *def, datalog_element::VIEW_LEVEL lvl);
  datalog_packet *current_display_packet;
  datalog_definition *def;
  datalog_element::VIEW_LEVEL lvl;
  void refresh_display();
  bool print_errors;
  void reconfigure();
  int patch_level;
  void showEvent(QShowEvent *event);
  void update_pktage(datalog_packet *packet);
  void error_dialog(QString msg);
  unsigned int n_errors;
public slots:
  void new_packet_recieved(datalog_packet *packet);
  void new_patch_level(int patch_level_in); // FIXME connect !!!
  void display_config_changed();
private slots:
  void on_filter_slider_valueChanged(int value);
  void on_get_once_btn_clicked();
  void on_acquire_btn_toggled(bool checked);
  void on_btn_exportcsv_clicked();
  void on_rate_slider_valueChanged(int value);
};

#endif // DATALOG_EXTENDED_H
